/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.couchbase.document;

import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;
import org.springframework.data.couchbase.repository.support.DBRef;
import org.springframework.data.domain.Sort;

public abstract class CouchbaseDocumentSerializer
implements Visitor<Object, Void> {
    boolean workInProgress = true;

    public Object handle(Expression<?> expression) {
        return expression.accept((Visitor)this, null);
    }

    public Sort toSort(List<OrderSpecifier<?>> orderBys) {
        Sort sort = Sort.unsorted();
        for (OrderSpecifier<?> orderBy : orderBys) {
            Object object = orderBy.getTarget().accept((Visitor)this, null);
        }
        return sort;
    }

    public Object visit(Constant<?> expr, Void context) {
        if (Enum.class.isAssignableFrom(expr.getType())) {
            Constant<?> expectedExpr = expr;
            return ((Enum)expectedExpr.getConstant()).name();
        }
        return expr.getConstant();
    }

    public Object visit(TemplateExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(FactoryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    protected String asDBKey(Operation<?> expr, int index) {
        return (String)this.asDBValue(expr, index);
    }

    protected Object asDBValue(Operation<?> expr, int index) {
        return expr.getArg(index).accept((Visitor)this, null);
    }

    private String regexValue(Operation<?> expr, int index) {
        return Pattern.quote(expr.getArg(index).accept((Visitor)this, null).toString());
    }

    protected QueryCriteriaDefinition asDocument(String key, Object value) {
        Object qc = null;
        throw new UnsupportedOperationException("Wrong path to create this criteria " + key);
    }

    public Object visit(Operation<?> expr, Void context) {
        Operator op = expr.getOperator();
        if (op == Ops.EQ) {
            if (expr.getArg(0) instanceof Operation) {
                Operation lhs = (Operation)expr.getArg(0);
                if (lhs.getOperator() == Ops.COL_SIZE || lhs.getOperator() == Ops.ARRAY_SIZE || lhs.getOperator() == Ops.STRING_LENGTH) {
                    return QueryCriteria.where(this.asDBKey(expr, 0)).is(this.asDBValue(expr, 1));
                }
                throw new UnsupportedOperationException("Illegal operation " + expr);
            }
            if (expr.getArg(0) instanceof Path) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).is(this.asDBValue(expr, 1));
            }
        } else {
            if (op == Ops.STRING_IS_EMPTY) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).isNotValued().or(this.asDBKey(expr, 0)).is("");
            }
            if (op == Ops.NOT) {
                Operation subOperation = (Operation)expr.getArg(0);
                Operator subOp = subOperation.getOperator();
                if (subOp == Ops.IN) {
                    return this.visit(ExpressionUtils.operation(Boolean.class, (Operator)Ops.NOT_IN, (Expression[])new Expression[]{subOperation.getArg(0), subOperation.getArg(1)}), context);
                }
                QueryCriteria arg = (QueryCriteria)this.handle(expr.getArg(0));
                return arg.negate();
            }
            if (op == Ops.AND) {
                return this.collectConnectorArgs("$and", expr);
            }
            if (op == Ops.OR) {
                return this.collectConnectorArgs("$or", expr);
            }
            if (op == Ops.NE) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).ne(this.asDBValue(expr, 1));
            }
            if (op == Ops.STARTS_WITH) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).startingWith(this.asDBValue(expr, 1));
            }
            if (op == Ops.STARTS_WITH_IC) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).upper().startingWith(this.asDBValue(expr, 1).toString().toUpperCase(Locale.ROOT));
            }
            if (op == Ops.ENDS_WITH) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).endingWith(this.asDBValue(expr, 1));
            }
            if (op == Ops.ENDS_WITH_IC) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).upper().endingWith(this.asDBValue(expr, 1).toString().toUpperCase(Locale.ROOT));
            }
            if (op == Ops.EQ_IGNORE_CASE) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).upper().eq(this.asDBValue(expr, 1).toString().toUpperCase(Locale.ROOT));
            }
            if (op == Ops.STRING_CONTAINS) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).containing(this.asDBValue(expr, 1));
            }
            if (op == Ops.STRING_CONTAINS_IC) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).upper().containing(this.asDBValue(expr, 1).toString().toUpperCase(Locale.ROOT));
            }
            if (op == Ops.LIKE) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).like(this.asDBValue(expr, 1));
            }
            if (op == Ops.LIKE_IC) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).upper().like(this.asDBValue(expr, 1).toString().toUpperCase(Locale.ROOT));
            }
            if (op == Ops.BETWEEN) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).between(this.asDBValue(expr, 1), this.asDBValue(expr, 2));
            }
            if (op == Ops.IN) {
                int constIndex = 0;
                int exprIndex = 1;
                if (expr.getArg(1) instanceof Constant) {
                    constIndex = 1;
                    exprIndex = 0;
                }
                if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                    Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                    return QueryCriteria.where(this.asDBKey(expr, exprIndex)).in(values);
                }
                Expression value = expr.getArg(constIndex);
                return QueryCriteria.where(this.asDBKey(expr, exprIndex)).eq(value);
            }
            if (op == Ops.NOT_IN) {
                int constIndex = 0;
                int exprIndex = 1;
                if (expr.getArg(1) instanceof Constant) {
                    constIndex = 1;
                    exprIndex = 0;
                }
                if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                    Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                    return QueryCriteria.where(this.asDBKey(expr, exprIndex)).notIn(values);
                }
                Expression value = expr.getArg(constIndex);
                return QueryCriteria.where(this.asDBKey(expr, exprIndex)).ne(value);
            }
            if (op == Ops.COL_IS_EMPTY) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).isNotValued();
            }
            if (op == Ops.LT) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).lt(this.asDBValue(expr, 1));
            }
            if (op == Ops.GT) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).gt(this.asDBValue(expr, 1));
            }
            if (op == Ops.LOE) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).lte(this.asDBValue(expr, 1));
            }
            if (op == Ops.GOE) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).gte(this.asDBValue(expr, 1));
            }
            if (op == Ops.IS_NULL) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).isNull();
            }
            if (op == Ops.IS_NOT_NULL) {
                return QueryCriteria.where(this.asDBKey(expr, 0)).isNotNull();
            }
            if (op == Ops.CONTAINS_KEY) {
                Path path = (Path)expr.getArg(0);
                return QueryCriteria.where("meta().id").eq(this.asDBKey(expr, 1));
            }
            if (op == Ops.STRING_LENGTH) {
                return "LENGTH(" + this.asDBKey(expr, 0) + ")";
            }
        }
        throw new UnsupportedOperationException("Illegal operation " + expr);
    }

    protected boolean isImplicitObjectIdConversion() {
        return true;
    }

    protected DBRef asReferenceKey(Class<?> entity, Object id) {
        throw new UnsupportedOperationException();
    }

    protected abstract DBRef asReference(Object var1);

    protected abstract boolean isReference(Path<?> var1);

    protected boolean isId(Path<?> arg) {
        return false;
    }

    public String visit(Path<?> expr, Void context) {
        PathMetadata metadata = expr.getMetadata();
        if (metadata.getParent() != null) {
            Path parent = metadata.getParent();
            if (parent.getMetadata().getPathType() == PathType.DELEGATE) {
                parent = parent.getMetadata().getParent();
            }
            if (metadata.getPathType() == PathType.COLLECTION_ANY) {
                return this.visit(parent, context);
            }
            if (parent.getMetadata().getPathType() != PathType.VARIABLE) {
                String rv = this.getKeyForPath(expr, metadata);
                String parentStr = this.visit(parent, context);
                return rv != null ? parentStr + "." + rv : parentStr;
            }
        }
        return this.getKeyForPath(expr, metadata);
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        return metadata.getElement().toString();
    }

    public Object visit(SubQueryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(ParamExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    private QueryCriteriaDefinition collectConnectorArgs(String operator, Operation<?> operation) {
        QueryCriteria first = null;
        for (Expression exp : operation.getArgs()) {
            QueryCriteria document = (QueryCriteria)this.handle(exp);
            if (first == null) {
                first = document;
                continue;
            }
            if (operator.equals("$or")) {
                first = first.or(document);
                continue;
            }
            if (!operator.equals("$and")) continue;
            first = first.and(document);
        }
        return first;
    }
}

