/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import java.io.Serializable;
import java.util.Iterator;

public class N1QLExpression {
    private static final N1QLExpression NULL_INSTANCE = new N1QLExpression("NULL");
    private static final N1QLExpression TRUE_INSTANCE = new N1QLExpression("TRUE");
    private static final N1QLExpression FALSE_INSTANCE = new N1QLExpression("FALSE");
    private static final N1QLExpression MISSING_INSTANCE = new N1QLExpression("MISSING");
    private static final N1QLExpression EMPTY_INSTANCE = new N1QLExpression("");
    private Object value;

    private N1QLExpression(Object value) {
        this.value = value;
    }

    public static N1QLExpression x(String value) {
        return new N1QLExpression(value);
    }

    public static N1QLExpression i(String ... identifiers) {
        return new N1QLExpression(N1QLExpression.wrapWith('`', identifiers));
    }

    public static N1QLExpression s(String ... strings) {
        return new N1QLExpression(N1QLExpression.wrapWith('\"', strings));
    }

    public static N1QLExpression TRUE() {
        return TRUE_INSTANCE;
    }

    public static N1QLExpression FALSE() {
        return FALSE_INSTANCE;
    }

    public static N1QLExpression NULL() {
        return NULL_INSTANCE;
    }

    public static N1QLExpression WRAPPER() {
        return EMPTY_INSTANCE;
    }

    public static N1QLExpression MISSING() {
        return MISSING_INSTANCE;
    }

    private static N1QLExpression prefix(String prefix, String right) {
        return new N1QLExpression(prefix + " " + right);
    }

    private static N1QLExpression infix(String infix, String left, String right) {
        return new N1QLExpression(left + " " + infix + " " + right);
    }

    private static N1QLExpression postfix(String postfix, String left) {
        return new N1QLExpression(left + " " + postfix);
    }

    public static N1QLExpression path(Object ... pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            return EMPTY_INSTANCE;
        }
        StringBuilder path = new StringBuilder();
        for (Object p : pathComponents) {
            path.append('.');
            if (p instanceof N1QLExpression) {
                path.append(((N1QLExpression)p).toString());
                continue;
            }
            path.append(String.valueOf(p));
        }
        path.deleteCharAt(0);
        return N1QLExpression.x(path.toString());
    }

    public static N1QLExpression meta(N1QLExpression expression) {
        return N1QLExpression.x("META(" + expression.toString() + ")");
    }

    public static N1QLExpression select(N1QLExpression ... expressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < expressions.length; ++i) {
            sb.append(expressions[i].toString());
            if (i >= expressions.length - 1) continue;
            sb.append(", ");
        }
        return N1QLExpression.x(sb.toString());
    }

    public static N1QLExpression delete() {
        return N1QLExpression.x("DELETE");
    }

    public static N1QLExpression count(N1QLExpression expression) {
        return N1QLExpression.x("COUNT(" + expression.toString() + ")");
    }

    private static String wrapWith(char wrapper, String ... input) {
        StringBuilder escaped = new StringBuilder();
        for (String i : input) {
            escaped.append(", ");
            escaped.append(wrapper).append(i).append(wrapper);
        }
        if (escaped.length() > 2) {
            escaped.delete(0, 2);
        }
        return escaped.toString();
    }

    public N1QLExpression and(N1QLExpression right) {
        return N1QLExpression.infix("AND", this.toString(), right.toString());
    }

    public N1QLExpression or(N1QLExpression right) {
        return N1QLExpression.infix("OR", this.toString(), right.toString());
    }

    public N1QLExpression as(N1QLExpression alias) {
        return N1QLExpression.infix("AS", this.toString(), alias.toString());
    }

    public N1QLExpression from(N1QLExpression bucketName) {
        return N1QLExpression.infix("FROM", this.toString(), bucketName.toString());
    }

    public N1QLExpression from(String bucketName) {
        return this.from(N1QLExpression.i(bucketName));
    }

    public N1QLExpression where(N1QLExpression right) {
        return N1QLExpression.infix("WHERE", this.toString(), right.toString());
    }

    public N1QLExpression returning(N1QLExpression right) {
        return N1QLExpression.infix("RETURNING", this.toString(), right.toString());
    }

    public N1QLExpression keys(Iterable<? extends Serializable> ids) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends Serializable> it = ids.iterator();
        sb.append("[");
        while (it.hasNext()) {
            sb.append(N1QLExpression.s(it.next().toString()));
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return N1QLExpression.infix("USE KEYS", this.toString(), sb.toString());
    }

    public N1QLExpression lower() {
        return N1QLExpression.x("LOWER(" + this.toString() + ")");
    }

    public N1QLExpression convertToString() {
        return N1QLExpression.x("TOSTRING(" + this.toString() + ")");
    }

    public N1QLExpression eq(N1QLExpression right) {
        return N1QLExpression.infix("=", this.toString(), right.toString());
    }

    public N1QLExpression eq(boolean value) {
        return value ? this.eq(TRUE_INSTANCE) : this.eq(FALSE_INSTANCE);
    }

    public N1QLExpression asc() {
        return N1QLExpression.postfix("ASC", this.toString());
    }

    public N1QLExpression desc() {
        return N1QLExpression.postfix("DESC", this.toString());
    }

    public N1QLExpression limit(int limit) {
        return N1QLExpression.infix("LIMIT", this.toString(), String.valueOf(limit));
    }

    public N1QLExpression offset(int offset) {
        return N1QLExpression.infix("OFFSET", this.toString(), String.valueOf(offset));
    }

    public N1QLExpression between(N1QLExpression right) {
        return N1QLExpression.infix("BETWEEN", this.toString(), right.toString());
    }

    public N1QLExpression gt(N1QLExpression right) {
        return N1QLExpression.infix(">", this.toString(), right.toString());
    }

    public N1QLExpression isNull() {
        return N1QLExpression.postfix("IS NULL", this.toString());
    }

    public N1QLExpression isNotNull() {
        return N1QLExpression.postfix("IS NOT NULL", this.toString());
    }

    public N1QLExpression ne(N1QLExpression right) {
        return N1QLExpression.infix("!=", this.toString(), right.toString());
    }

    public N1QLExpression gte(N1QLExpression right) {
        return N1QLExpression.infix(">=", this.toString(), right.toString());
    }

    public N1QLExpression lte(N1QLExpression right) {
        return N1QLExpression.infix("<=", this.toString(), right.toString());
    }

    public N1QLExpression like(N1QLExpression right) {
        return N1QLExpression.infix("LIKE", this.toString(), right.toString());
    }

    public N1QLExpression notLike(N1QLExpression right) {
        return N1QLExpression.infix("NOT LIKE", this.toString(), right.toString());
    }

    public N1QLExpression in(N1QLExpression right) {
        return N1QLExpression.infix("IN", this.toString(), right.toString());
    }

    public N1QLExpression notIn(N1QLExpression right) {
        return N1QLExpression.infix("NOT IN", this.toString(), right.toString());
    }

    public N1QLExpression isNotMissing() {
        return N1QLExpression.postfix("IS NOT MISSING", this.toString());
    }

    public N1QLExpression lt(N1QLExpression right) {
        return N1QLExpression.infix("<", this.toString(), right.toString());
    }

    public N1QLExpression orderBy(N1QLExpression ... expressions) {
        StringBuilder sbOrderClause = new StringBuilder();
        for (int i = 0; i < expressions.length; ++i) {
            sbOrderClause.append(expressions[i].toString());
            if (expressions.length - 1 <= i) continue;
            sbOrderClause.append(", ");
        }
        return N1QLExpression.infix("ORDER BY", this.toString(), sbOrderClause.toString());
    }

    public String toString() {
        return this.value.toString();
    }
}

