/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.EmptyCloseableIterator;
import com.querydsl.core.Fetchable;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.support.BasicQuery;
import org.springframework.data.couchbase.repository.support.SpringDataCouchbaseQuerySupport;
import org.springframework.data.couchbase.repository.support.SpringDataCouchbaseSerializer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;

public class SpringDataCouchbaseQuery<T>
extends SpringDataCouchbaseQuerySupport<SpringDataCouchbaseQuery<T>>
implements Fetchable<T> {
    private final CouchbaseOperations couchbaseOperations;
    private final Consumer<BasicQuery> queryCustomizer;
    private final ExecutableFindByQueryOperation.ExecutableFindByQuery<T> find;

    public SpringDataCouchbaseQuery(CouchbaseOperations operations, Class<? extends T> type) {
        this(operations, type, "_default");
    }

    public SpringDataCouchbaseQuery(CouchbaseOperations operations, Class<? extends T> type, String collectionName) {
        this(operations, type, type, collectionName, it -> {});
    }

    SpringDataCouchbaseQuery(CouchbaseOperations operations, Class<?> domainType, Class<? extends T> resultType, String collectionName, Consumer<BasicQuery> queryCustomizer) {
        super(new SpringDataCouchbaseSerializer(operations.getConverter()));
        Class<? extends T> resultType1 = resultType;
        this.couchbaseOperations = operations;
        this.queryCustomizer = queryCustomizer;
        this.find = (ExecutableFindByQueryOperation.ExecutableFindByQuery)this.couchbaseOperations.findByQuery(domainType).as(resultType1).inCollection(collectionName);
    }

    public CloseableIterator<T> iterate() {
        try {
            final Stream<T> stream = this.stream();
            final Iterator iterator = stream.iterator();
            return new CloseableIterator<T>(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public T next() {
                    return iterator.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove from iterator while streaming data.");
                }

                public void close() {
                    stream.close();
                }
            };
        }
        catch (RuntimeException e) {
            return (CloseableIterator)SpringDataCouchbaseQuery.handleException(e, new EmptyCloseableIterator());
        }
    }

    public Stream<T> stream() {
        try {
            return this.find.matching(this.createQuery()).stream();
        }
        catch (RuntimeException e) {
            return SpringDataCouchbaseQuery.handleException(e, Stream.empty());
        }
    }

    public List<T> fetch() {
        try {
            return this.find.matching(this.createQuery()).all();
        }
        catch (RuntimeException e) {
            return SpringDataCouchbaseQuery.handleException(e, Collections.emptyList());
        }
    }

    public Page<T> fetchPage(Pageable pageable) {
        try {
            Collection content = this.find.matching(this.createQuery().with(pageable)).all();
            return PageableExecutionUtils.getPage((List)content, (Pageable)pageable, this::fetchCount);
        }
        catch (RuntimeException e) {
            return (Page)SpringDataCouchbaseQuery.handleException(e, new PageImpl(Collections.emptyList(), pageable, 0L));
        }
    }

    public T fetchFirst() {
        try {
            return this.find.matching(this.createQuery()).firstValue();
        }
        catch (RuntimeException e) {
            return SpringDataCouchbaseQuery.handleException(e, null);
        }
    }

    public T fetchOne() {
        try {
            return this.find.matching(this.createQuery()).oneValue();
        }
        catch (RuntimeException e) {
            return SpringDataCouchbaseQuery.handleException(e, null);
        }
    }

    public QueryResults<T> fetchResults() {
        long total = this.fetchCount();
        return total > 0L ? new QueryResults(this.fetch(), this.getQueryMixin().getMetadata().getModifiers(), total) : QueryResults.emptyResults();
    }

    public long fetchCount() {
        try {
            return this.find.matching(this.createQuery().skip(-1L).limit(-1)).count();
        }
        catch (RuntimeException e) {
            return SpringDataCouchbaseQuery.handleException(e, 0L);
        }
    }

    protected Query createQuery() {
        QueryMetadata metadata = this.getQueryMixin().getMetadata();
        return this.createQuery(this.createFilter(metadata), metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    @Override
    protected Predicate createFilter(QueryMetadata metadata) {
        return metadata.getWhere();
    }

    @Override
    protected List<Object> getIds(Class<?> var1, Predicate var2) {
        return null;
    }

    protected Query createQuery(@Nullable Predicate filter, @Nullable Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        Map<String, String> fields = this.createProjection(projection);
        BasicQuery basicQuery = new BasicQuery(this.createCriteria(filter), fields);
        Integer limit = modifiers.getLimitAsInteger();
        Integer offset = modifiers.getOffsetAsInteger();
        if (limit != null) {
            basicQuery.limit(limit);
        }
        if (offset != null) {
            basicQuery.skip(offset.intValue());
        }
        if (orderBy.size() > 0) {
            basicQuery.setSort(this.createSort(orderBy));
        }
        this.queryCustomizer.accept(basicQuery);
        return basicQuery;
    }

    private static <T> T handleException(RuntimeException e, T defaultValue) {
        if (e.getClass().getName().endsWith("$NoResults")) {
            return defaultValue;
        }
        throw e;
    }
}

