/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.java.encryption.annotation.Encrypted;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.PropertyValueConverterRegistrar;
import org.springframework.data.convert.SimplePropertyValueConversions;
import org.springframework.data.couchbase.core.convert.CouchbaseJsr310Converters;
import org.springframework.data.couchbase.core.convert.DateConverters;
import org.springframework.data.couchbase.core.convert.OtherConverters;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public class CouchbaseCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Object> STORE_CONVERTERS;

    public CouchbaseCustomConversions(List<?> converters) {
        this(CouchbaseConverterConfigurationAdapter.from(converters));
    }

    protected CouchbaseCustomConversions(CouchbaseConverterConfigurationAdapter conversionConfiguration) {
        super(conversionConfiguration.createConverterConfiguration());
    }

    public static CouchbaseCustomConversions create(Consumer<CouchbaseConverterConfigurationAdapter> configurer) {
        CouchbaseConverterConfigurationAdapter adapter = new CouchbaseConverterConfigurationAdapter();
        configurer.accept(adapter);
        return new CouchbaseCustomConversions(adapter);
    }

    public boolean hasValueConverter(PersistentProperty<?> property) {
        if (property.findAnnotation(Encrypted.class) != null) {
            return true;
        }
        return super.hasValueConverter(property);
    }

    static {
        ArrayList converters = new ArrayList();
        converters.addAll(DateConverters.getConvertersToRegister());
        converters.addAll(CouchbaseJsr310Converters.getConvertersToRegister());
        converters.addAll(OtherConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)SimpleTypeHolder.DEFAULT, STORE_CONVERTERS);
    }

    public static class CouchbaseConverterConfigurationAdapter {
        private static final Set<Class<?>> JAVA_DRIVER_TIME_SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(LocalDate.class, LocalTime.class, LocalDateTime.class));
        private boolean useNativeDriverJavaTimeCodecs = false;
        private final List<Object> customConverters = new ArrayList<Object>();
        private final PropertyValueConversions internalValueConversion;
        private PropertyValueConversions propertyValueConversions = this.internalValueConversion = PropertyValueConversions.simple(it -> {});

        public static CouchbaseConverterConfigurationAdapter from(List<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            CouchbaseConverterConfigurationAdapter converterConfigurationAdapter = new CouchbaseConverterConfigurationAdapter();
            converterConfigurationAdapter.registerConverters(converters);
            return converterConfigurationAdapter;
        }

        public CouchbaseConverterConfigurationAdapter registerConverter(Converter<?, ?> converter) {
            Assert.notNull(converter, (String)"Converter must not be null!");
            this.customConverters.add(converter);
            return this;
        }

        public CouchbaseConverterConfigurationAdapter configurePropertyConversions(Consumer<PropertyValueConverterRegistrar<CouchbasePersistentProperty>> configurationAdapter) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry");
            PropertyValueConverterRegistrar propertyValueConverterRegistrar = new PropertyValueConverterRegistrar();
            configurationAdapter.accept((PropertyValueConverterRegistrar<CouchbasePersistentProperty>)propertyValueConverterRegistrar);
            ((SimplePropertyValueConversions)this.valueConversions()).setValueConverterRegistry(propertyValueConverterRegistrar.buildRegistry());
            return this;
        }

        public CouchbaseConverterConfigurationAdapter registerConverterFactory(ConverterFactory<?, ?> converterFactory) {
            Assert.notNull(converterFactory, (String)"ConverterFactory must not be null");
            this.customConverters.add(converterFactory);
            return this;
        }

        public CouchbaseConverterConfigurationAdapter registerConverters(Collection<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            Assert.noNullElements(converters, (String)"Converters must not be null nor contain null values");
            this.customConverters.addAll(converters);
            return this;
        }

        public CouchbaseConverterConfigurationAdapter registerPropertyValueConverterFactory(PropertyValueConverterFactory converterFactory) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry");
            ((SimplePropertyValueConversions)this.valueConversions()).setConverterFactory(converterFactory);
            return this;
        }

        public CouchbaseConverterConfigurationAdapter setPropertyValueConversions(PropertyValueConversions valueConversions) {
            Assert.notNull((Object)valueConversions, (String)"PropertyValueConversions must not be null");
            this.propertyValueConversions = valueConversions;
            return this;
        }

        PropertyValueConversions valueConversions() {
            if (this.propertyValueConversions == null) {
                this.propertyValueConversions = this.internalValueConversion;
            }
            return this.propertyValueConversions;
        }

        CustomConversions.ConverterConfiguration createConverterConfiguration() {
            PropertyValueConversions propertyValueConversions;
            if (this.hasDefaultPropertyValueConversions() && (propertyValueConversions = this.propertyValueConversions) instanceof SimplePropertyValueConversions) {
                SimplePropertyValueConversions svc = (SimplePropertyValueConversions)propertyValueConversions;
                svc.init();
            }
            if (!this.useNativeDriverJavaTimeCodecs) {
                return new CustomConversions.ConverterConfiguration(STORE_CONVERSIONS, this.customConverters, convertiblePair -> true, this.propertyValueConversions);
            }
            ArrayList<Object> converters = new ArrayList<Object>(STORE_CONVERTERS.size() + 3);
            converters.add((Object)DateToUtcLocalDateConverter.INSTANCE);
            converters.add((Object)DateToUtcLocalTimeConverter.INSTANCE);
            converters.add((Object)DateToUtcLocalDateTimeConverter.INSTANCE);
            converters.addAll(STORE_CONVERTERS);
            CustomConversions.StoreConversions storeConversions = CustomConversions.StoreConversions.of((SimpleTypeHolder)new SimpleTypeHolder(JAVA_DRIVER_TIME_SIMPLE_TYPES, SimpleTypeHolder.DEFAULT), converters);
            return new CustomConversions.ConverterConfiguration(storeConversions, this.customConverters, convertiblePair -> !JAVA_DRIVER_TIME_SIMPLE_TYPES.contains(convertiblePair.getSourceType()) || !Date.class.isAssignableFrom(convertiblePair.getTargetType()), this.propertyValueConversions);
        }

        private boolean hasDefaultPropertyValueConversions() {
            return this.propertyValueConversions == this.internalValueConversion;
        }

        private static enum DateToUtcLocalDateConverter implements Converter<Date, LocalDate>
        {
            INSTANCE;


            public LocalDate convert(Date source) {
                return DateToUtcLocalDateTimeConverter.INSTANCE.convert(source).toLocalDate();
            }
        }

        private static enum DateToUtcLocalTimeConverter implements Converter<Date, LocalTime>
        {
            INSTANCE;


            public LocalTime convert(Date source) {
                return DateToUtcLocalDateTimeConverter.INSTANCE.convert(source).toLocalTime();
            }
        }

        private static enum DateToUtcLocalDateTimeConverter implements Converter<Date, LocalDateTime>
        {
            INSTANCE;


            public LocalDateTime convert(Date source) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(source.getTime()), ZoneId.of("UTC"));
            }
        }
    }
}

