/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.couchbase.core.convert.CryptoConverter;
import org.springframework.data.mapping.PersistentProperty;

public class CouchbasePropertyValueConverterFactory
implements PropertyValueConverterFactory {
    CryptoManager cryptoManager;
    Map<Class<? extends PropertyValueConverter<?, ?, ?>>, PropertyValueConverter<?, ?, ?>> converterCache = new HashMap();

    public CouchbasePropertyValueConverterFactory(CryptoManager cryptoManager) {
        this.cryptoManager = cryptoManager;
    }

    public <DV, SV, P extends ValueConversionContext<?>> PropertyValueConverter<DV, SV, P> getConverter(PersistentProperty<?> property) {
        PropertyValueConverter valueConverter = super.getConverter(property);
        if (valueConverter != null) {
            return valueConverter;
        }
        Encrypted encryptedAnn = (Encrypted)property.findAnnotation(Encrypted.class);
        if (encryptedAnn != null) {
            Class<CryptoConverter> cryptoConverterClass = CryptoConverter.class;
            return this.getConverter(cryptoConverterClass);
        }
        return null;
    }

    public <DV, SV, P extends ValueConversionContext<?>> PropertyValueConverter<DV, SV, P> getConverter(Class<? extends PropertyValueConverter<DV, SV, P>> converterType) {
        PropertyValueConverter<DV, SV, P> converter = this.converterCache.get(converterType);
        if (converter != null) {
            return converter;
        }
        if (CryptoConverter.class.isAssignableFrom(converterType)) {
            converter = new PropertyValueConverter<DV, SV, P>(this.cryptoManager);
        } else {
            try {
                Constructor<PropertyValueConverter<DV, SV, P>> constructor = converterType.getConstructor(new Class[0]);
                converter = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.converterCache.put(converter.getClass(), converter);
        return converter;
    }
}

