/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.couchbase.core.convert.AbstractCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.CouchbaseConversionContext;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class CryptoConverter
implements PropertyValueConverter<Object, CouchbaseDocument, ValueConversionContext<? extends PersistentProperty<?>>> {
    CryptoManager cryptoManager;

    public CryptoConverter(CryptoManager cryptoManager) {
        this.cryptoManager = cryptoManager;
    }

    public Object read(CouchbaseDocument value, ValueConversionContext<? extends PersistentProperty<?>> context) {
        byte[] decrypted = this.cryptoManager().decrypt(value.export());
        if (decrypted == null) {
            return null;
        }
        return this.coerceToValueRead(decrypted, (CouchbaseConversionContext)context);
    }

    public CouchbaseDocument write(Object value, ValueConversionContext<? extends PersistentProperty<?>> context) {
        CouchbaseConversionContext ctx = (CouchbaseConversionContext)context;
        CouchbasePersistentProperty property = ctx.getProperty();
        byte[] plainText = this.coerceToBytesWrite(property, ctx.getAccessor(), ctx);
        Map encrypted = this.cryptoManager().encrypt(plainText, ((Encrypted)ctx.getProperty().findAnnotation(Encrypted.class)).encrypter());
        return new CouchbaseDocument().setContent(encrypted);
    }

    private Object coerceToValueRead(byte[] decrypted, CouchbaseConversionContext context) {
        CouchbasePersistentProperty property = context.getProperty();
        CustomConversions cnvs = context.getConverter().getConversions();
        ConversionService svc = context.getConverter().getConversionService();
        Class type = property.getType();
        String decryptedString = new String(decrypted);
        if ("null".equals(decryptedString)) {
            return null;
        }
        if (!cnvs.isSimpleType(type) && !type.isArray()) {
            JsonObject jo = JsonObject.fromJson((String)decryptedString);
            CouchbaseDocument source = new CouchbaseDocument().setContent(jo);
            return context.getConverter().read(property.getTypeInformation(), source);
        }
        String jsonString = "{\"" + property.getFieldName() + "\":" + decryptedString + "}";
        try {
            CouchbaseDocument decryptedDoc = new CouchbaseDocument().setContent(JsonObject.fromJson((String)jsonString));
            return context.getConverter().getPotentiallyConvertedSimpleRead(decryptedDoc.get(property.getFieldName()), property);
        }
        catch (InvalidArgumentException | ConversionFailedException | ConverterNotFoundException e) {
            throw new RuntimeException(decryptedString, e);
        }
    }

    private byte[] coerceToBytesWrite(CouchbasePersistentProperty property, ConvertingPropertyAccessor accessor, CouchbaseConversionContext context) {
        byte[] plainText;
        CustomConversions cnvs = context.getConverter().getConversions();
        Class sourceType = property.getType();
        Class targetType = cnvs.getCustomWriteTarget(property.getType()).orElse(null);
        Object value = context.getConverter().getPotentiallyConvertedSimpleWrite(property, (ConvertingPropertyAccessor<Object>)accessor, false);
        if (value == null) {
            plainText = "null".getBytes(StandardCharsets.UTF_8);
        } else if (value.getClass().isArray()) {
            JsonArray ja = value.getClass().getComponentType().isPrimitive() ? this.jaFromPrimitiveArray(value) : this.jaFromObjectArray(value, context.getConverter());
            plainText = ja.toBytes();
        } else if (cnvs.isSimpleType(sourceType)) {
            Object plainString;
            Object object = plainString = value != null ? value.toString() : null;
            if (sourceType == String.class || targetType == String.class || sourceType == Character.class || sourceType == Character.TYPE || Enum.class.isAssignableFrom(sourceType) || Locale.class.isAssignableFrom(sourceType)) {
                plainString = "\"" + ((String)plainString).replaceAll("\"", "\\\"") + "\"";
            }
            plainText = ((String)plainString).getBytes(StandardCharsets.UTF_8);
        } else {
            plainText = JsonObject.fromJson((byte[])context.read(value).toString().getBytes(StandardCharsets.UTF_8)).toBytes();
        }
        return plainText;
    }

    CryptoManager cryptoManager() {
        Assert.notNull((Object)this.cryptoManager, (String)("cryptoManager needed to encrypt/decrypt but it is null. Override needed for cryptoManager() method of " + AbstractCouchbaseConverter.class.getName()));
        return this.cryptoManager;
    }

    JsonArray jaFromObjectArray(Object value, MappingCouchbaseConverter converter) {
        CustomConversions cnvs = converter.getConversions();
        ConversionService svc = converter.getConversionService();
        JsonArray ja = JsonArray.ja();
        for (Object o : (Object[])value) {
            ja.add(this.coerceToJson(o, cnvs, svc));
        }
        return ja;
    }

    JsonArray jaFromPrimitiveArray(Object value) {
        JsonArray jArray;
        Class<?> component = value.getClass().getComponentType();
        if (Long.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_long((long[])value);
        } else if (Integer.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_int((int[])value);
        } else if (Double.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_double((double[])value);
        } else if (Float.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_float((float[])value);
        } else if (Boolean.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_boolean((boolean[])value);
        } else if (Short.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_short((short[])value);
        } else if (Byte.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_byte((byte[])value);
        } else if (Character.TYPE.isAssignableFrom(component)) {
            jArray = this.ja_char((char[])value);
        } else {
            throw new RuntimeException("unhandled primitive array: " + component.getName());
        }
        return jArray;
    }

    JsonArray ja_long(long[] array) {
        JsonArray ja = JsonArray.ja();
        for (long t : array) {
            ja.add(t);
        }
        return ja;
    }

    JsonArray ja_int(int[] array) {
        JsonArray ja = JsonArray.ja();
        for (int t : array) {
            ja.add(t);
        }
        return ja;
    }

    JsonArray ja_double(double[] array) {
        JsonArray ja = JsonArray.ja();
        for (double t : array) {
            ja.add(t);
        }
        return ja;
    }

    JsonArray ja_float(float[] array) {
        JsonArray ja = JsonArray.ja();
        for (float t : array) {
            ja.add((double)t);
        }
        return ja;
    }

    JsonArray ja_boolean(boolean[] array) {
        JsonArray ja = JsonArray.ja();
        for (boolean t : array) {
            ja.add(t);
        }
        return ja;
    }

    JsonArray ja_short(short[] array) {
        JsonArray ja = JsonArray.ja();
        for (short t : array) {
            ja.add((int)t);
        }
        return ja;
    }

    JsonArray ja_byte(byte[] array) {
        JsonArray ja = JsonArray.ja();
        for (byte t : array) {
            ja.add((int)t);
        }
        return ja;
    }

    JsonArray ja_char(char[] array) {
        JsonArray ja = JsonArray.ja();
        for (char t : array) {
            ja.add(String.valueOf(t));
        }
        return ja;
    }

    Object coerceToJson(Object o, CustomConversions cnvs, ConversionService svc) {
        if (o != null && o.getClass() == Optional.class) {
            Object object = o = ((Optional)o).isEmpty() ? null : (Object)((Optional)o).get();
        }
        if (o == null) {
            o = JsonValue.NULL;
        } else {
            Optional clazz = cnvs.getCustomWriteTarget(o.getClass());
            if (clazz.isPresent()) {
                o = svc.convert(o, (Class)clazz.get());
            } else if (!JsonObject.checkType((Object)o)) {
                o = Number.class.isAssignableFrom(o.getClass()) ? (o.toString().contains(".") ? (Number)((Number)o).doubleValue() : (Number)((Number)o).longValue()) : (Character.class.isAssignableFrom(o.getClass()) ? ((Character)o).toString() : (Enum.class.isAssignableFrom(o.getClass()) ? ((Enum)o).name() : o.toString()));
            }
        }
        return o;
    }
}

