/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import com.couchbase.client.java.json.JsonObject;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.couchbase.core.convert.AbstractCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.CouchbaseConversionContext;
import org.springframework.data.couchbase.core.convert.CouchbaseCustomConversions;
import org.springframework.data.couchbase.core.convert.CouchbaseDocumentPropertyAccessor;
import org.springframework.data.couchbase.core.convert.CouchbaseTypeMapper;
import org.springframework.data.couchbase.core.convert.CryptoConverter;
import org.springframework.data.couchbase.core.convert.DefaultCouchbaseTypeMapper;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.id.GeneratedValue;
import org.springframework.data.couchbase.core.mapping.id.GenerationStrategy;
import org.springframework.data.couchbase.core.mapping.id.IdAttribute;
import org.springframework.data.couchbase.core.mapping.id.IdPrefix;
import org.springframework.data.couchbase.core.mapping.id.IdSuffix;
import org.springframework.data.couchbase.core.query.N1qlJoin;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingCouchbaseConverter
extends AbstractCouchbaseConverter
implements ApplicationContextAware {
    public static final String TYPEKEY_DEFAULT = "_class";
    public static final String TYPEKEY_SYNCGATEWAY_COMPATIBLE = "javaClass";
    protected final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final SpELContext spELContext;
    protected ApplicationContext applicationContext;
    protected CouchbaseTypeMapper typeMapper;
    @Nullable
    private EntityCallbacks entityCallbacks;

    public MappingCouchbaseConverter() {
        this((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)new CouchbaseMappingContext(), null);
    }

    public MappingCouchbaseConverter(MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext) {
        this(mappingContext, null);
    }

    public MappingCouchbaseConverter(MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext, String typeKey) {
        super((GenericConversionService)new DefaultConversionService());
        this.mappingContext = mappingContext;
        CouchbaseCustomConversions customConversions = new CouchbaseCustomConversions(Collections.emptyList());
        this.setCustomConversions(customConversions);
        ((CouchbaseMappingContext)mappingContext).setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        this.typeMapper = new DefaultCouchbaseTypeMapper(typeKey != null ? typeKey : TYPEKEY_DEFAULT);
        this.spELContext = new SpELContext((PropertyAccessor)CouchbaseDocumentPropertyAccessor.INSTANCE);
    }

    protected static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private static boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    public MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public String getTypeKey() {
        return this.typeMapper.getTypeKey();
    }

    @Override
    public Alias getTypeAlias(TypeInformation<?> info) {
        return this.typeMapper.getTypeAlias(info);
    }

    public <R> R read(Class<R> clazz, CouchbaseDocument source) {
        return this.read((TypeInformation<R>)ClassTypeInformation.from(clazz), source, (Object)null);
    }

    protected <R> R read(TypeInformation<R> type, CouchbaseDocument source) {
        return this.read(type, source, null);
    }

    protected <R> R read(TypeInformation<R> type, CouchbaseDocument source, Object parent) {
        if (source == null) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(source, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(source.getClass(), rawType)) {
            return (R)this.conversionService.convert((Object)source, rawType);
        }
        if (typeToUse.isMap()) {
            return (R)this.readMap(typeToUse, source, parent);
        }
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
        if (source.containsKey("encbooleans")) {
            System.err.println(source);
        }
        return this.read(entity, source, parent);
    }

    protected <R> R read(final CouchbasePersistentEntity<R> entity, final CouchbaseDocument source, final Object parent) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)source, this.spELContext);
        ParameterValueProvider<CouchbasePersistentProperty> provider = this.getParameterProvider(entity, source, evaluator, parent);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        final Object instance = instantiator.createInstance(entity, provider);
        final ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(instance);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CouchbasePersistentProperty>(){

            public void doWithPersistentProperty(CouchbasePersistentProperty prop) {
                if (!this.doesPropertyExistInSource(prop) || entity.isConstructorArgument(prop) || this.isIdConstructionProperty(prop) || prop.isAnnotationPresent(N1qlJoin.class)) {
                    return;
                }
                Object obj = prop == entity.getIdProperty() && parent == null ? source.getId() : MappingCouchbaseConverter.this.getValueInternal(prop, source, instance, entity);
                accessor.setProperty((PersistentProperty)prop, obj);
            }

            private boolean doesPropertyExistInSource(CouchbasePersistentProperty property) {
                return property.isIdProperty() || source.containsKey(property.getFieldName()) || source.containsKey(MappingCouchbaseConverter.this.maybeMangle(property));
            }

            private boolean isIdConstructionProperty(CouchbasePersistentProperty property) {
                return property.isAnnotationPresent(IdPrefix.class) || property.isAnnotationPresent(IdSuffix.class);
            }
        });
        entity.doWithAssociations(association -> {
            CouchbasePersistentProperty inverseProp = (CouchbasePersistentProperty)association.getInverse();
            Object obj = this.getValueInternal(inverseProp, source, instance, entity);
            accessor.setProperty((PersistentProperty)inverseProp, obj);
        });
        return (R)instance;
    }

    protected Object getValueInternal(CouchbasePersistentProperty property, CouchbaseDocument source, Object parent, PersistentEntity entity) {
        return new CouchbasePropertyValueProvider(source, this.spELContext, parent, entity).getPropertyValue(property);
    }

    private ParameterValueProvider<CouchbasePersistentProperty> getParameterProvider(CouchbasePersistentEntity<?> entity, CouchbaseDocument source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
        CouchbasePropertyValueProvider provider = new CouchbasePropertyValueProvider(source, evaluator, parent, entity);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, parent);
        return new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<CouchbasePersistentProperty>)parameterProvider, parent);
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, CouchbaseDocument source, Object parent) {
        Assert.notNull((Object)source, (String)"CouchbaseDocument must not be null!");
        Class mapType = this.typeMapper.readType(source, type).getType();
        Map map = CollectionFactory.createMap((Class)mapType, (int)source.export().keySet().size());
        Map<String, Object> sourceMap = source.getContent();
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            TypeInformation keyTypeInformation = type.getComponentType();
            if (keyTypeInformation != null) {
                Class keyType = keyTypeInformation.getType();
                key = this.conversionService.convert(key, keyType);
            }
            TypeInformation valueType = type.getMapValueType();
            if (value instanceof CouchbaseDocument) {
                map.put(key, this.read(valueType, (CouchbaseDocument)value, parent));
                continue;
            }
            if (value instanceof CouchbaseList) {
                map.put(key, this.readCollection(valueType, (CouchbaseList)value, parent));
                continue;
            }
            Class valueClass = valueType == null ? null : valueType.getType();
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueClass));
        }
        return map;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        if (Class.class.isAssignableFrom(target)) {
            try {
                return Class.forName(value.toString());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Unable to create class from " + value.toString());
            }
        }
        return target.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, target);
    }

    protected Object getPotentiallyConvertedSimpleRead(Object value, CouchbasePersistentProperty target) {
        if (value == null || target == null) {
            return value;
        }
        return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), new TypeDescriptor(target.getField()));
    }

    public void write(Object source, CouchbaseDocument target) {
        if (source == null) {
            return;
        }
        boolean isCustom = this.conversions.getCustomWriteTarget(source.getClass(), CouchbaseDocument.class).isPresent();
        ClassTypeInformation type = ClassTypeInformation.from(source.getClass());
        if (!isCustom) {
            this.typeMapper.writeType((TypeInformation)type, target);
        }
        this.writeInternalRoot(source, target, (TypeInformation<?>)type, true, null);
        if (target.getId() == null) {
            throw new MappingException("An ID property is needed, but not found/could not be generated on this entity.");
        }
    }

    public void writeInternalRoot(Object source, CouchbaseDocument target, TypeInformation<?> typeHint, boolean withId, CouchbasePersistentProperty property) {
        if (source == null) {
            return;
        }
        Optional customTarget = this.conversions.getCustomWriteTarget(source.getClass(), CouchbaseDocument.class);
        if (customTarget.isPresent()) {
            this.copyCouchbaseDocument((CouchbaseDocument)this.conversionService.convert(source, CouchbaseDocument.class), target);
            return;
        }
        if (Map.class.isAssignableFrom(source.getClass())) {
            this.writeMapInternal((Map)source, target, (TypeInformation<?>)ClassTypeInformation.MAP, property);
            return;
        }
        if (Collection.class.isAssignableFrom(source.getClass())) {
            throw new IllegalArgumentException("Root Document must be either CouchbaseDocument or Map.");
        }
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        this.writeInternalEntity(source, target, entity, withId, property);
        this.addCustomTypeKeyIfNecessary(typeHint, source, target);
    }

    protected void copyCouchbaseDocument(CouchbaseDocument source, CouchbaseDocument target) {
        for (Map.Entry<String, Object> entry : source.export().entrySet()) {
            target.put(entry.getKey(), entry.getValue());
        }
        target.setId(source.getId());
        target.setExpiration(source.getExpiration());
    }

    private String convertToString(Object propertyObj) {
        if (propertyObj instanceof String) {
            return (String)propertyObj;
        }
        if (propertyObj instanceof Number) {
            return new StringBuffer().append(propertyObj).toString();
        }
        return propertyObj.toString();
    }

    protected void writeInternalEntity(Object source, final CouchbaseDocument target, CouchbasePersistentEntity<?> entity, boolean withId, CouchbasePersistentProperty prop) {
        if (source == null) {
            return;
        }
        if (entity == null) {
            throw new MappingException("No mapping metadata found for entity of type " + source.getClass().getName());
        }
        final ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(source);
        CouchbasePersistentProperty idProperty = withId ? (CouchbasePersistentProperty)entity.getIdProperty() : null;
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)entity.getVersionProperty();
        GeneratedValue generatedValueInfo = null;
        TreeMap<Integer, String> prefixes = new TreeMap<Integer, String>();
        TreeMap<Integer, String> suffixes = new TreeMap<Integer, String>();
        TreeMap<Integer, String> idAttributes = new TreeMap<Integer, String>();
        target.setExpiration((int)entity.getExpiryDuration().getSeconds());
        this.writeToTargetDocument(target, entity, accessor, idProperty, versionProperty, prefixes, suffixes, idAttributes);
        if (idProperty != null && target.getId() == null) {
            String id = (String)accessor.getProperty((PersistentProperty)idProperty, String.class);
            if (idProperty.isAnnotationPresent(GeneratedValue.class) && (id == null || id.equals(""))) {
                generatedValueInfo = (GeneratedValue)idProperty.findAnnotation(GeneratedValue.class);
                String generatedId = this.generateId(generatedValueInfo, prefixes, suffixes, idAttributes);
                target.setId(generatedId);
                accessor.setProperty((PersistentProperty)idProperty, (Object)generatedId);
            } else {
                target.setId(id);
            }
        }
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<CouchbasePersistentProperty>(){

            public void doWithAssociation(Association<CouchbasePersistentProperty> association) {
                Class type;
                CouchbasePersistentProperty inverseProp = (CouchbasePersistentProperty)association.getInverse();
                Object propertyObj = accessor.getProperty((PersistentProperty)inverseProp, type = inverseProp.getType());
                if (null != propertyObj) {
                    MappingCouchbaseConverter.this.writePropertyInternal(propertyObj, target, inverseProp, accessor);
                }
            }
        });
        if (prop != null && this.conversions.hasValueConverter((PersistentProperty)prop)) {
            Map propertyConverted = (Map)this.conversions.getPropertyValueConversions().getValueConverter((PersistentProperty)prop).write(source, (ValueConversionContext)new CouchbaseConversionContext(prop, this, accessor));
            target.setContent(JsonObject.from((Map)propertyConverted));
        }
    }

    private void writeToTargetDocument(final CouchbaseDocument target, CouchbasePersistentEntity<?> entity, final ConvertingPropertyAccessor<Object> accessor, final CouchbasePersistentProperty idProperty, final CouchbasePersistentProperty versionProperty, final TreeMap<Integer, String> prefixes, final TreeMap<Integer, String> suffixes, final TreeMap<Integer, String> idAttributes) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CouchbasePersistentProperty>(){

            public void doWithPersistentProperty(CouchbasePersistentProperty prop) {
                if (prop.equals(idProperty) || versionProperty != null && prop.equals(versionProperty)) {
                    return;
                }
                if (prop.isAnnotationPresent(N1qlJoin.class)) {
                    return;
                }
                Object propertyObj = accessor.getProperty((PersistentProperty)prop, prop.getType());
                if (null != propertyObj) {
                    if (prop.isAnnotationPresent(IdPrefix.class)) {
                        IdPrefix prefix = (IdPrefix)prop.findAnnotation(IdPrefix.class);
                        int order = prefix.order();
                        prefixes.put(order, MappingCouchbaseConverter.this.convertToString(propertyObj));
                        return;
                    }
                    if (prop.isAnnotationPresent(IdSuffix.class)) {
                        IdSuffix suffix = (IdSuffix)prop.findAnnotation(IdSuffix.class);
                        int order = suffix.order();
                        suffixes.put(order, MappingCouchbaseConverter.this.convertToString(propertyObj));
                        return;
                    }
                    if (prop.isAnnotationPresent(IdAttribute.class)) {
                        IdAttribute idAttribute = (IdAttribute)prop.findAnnotation(IdAttribute.class);
                        int order = idAttribute.order();
                        idAttributes.put(order, MappingCouchbaseConverter.this.convertToString(propertyObj));
                    }
                    if (prop.isAnnotationPresent(Transient.class)) {
                        return;
                    }
                    if (!MappingCouchbaseConverter.this.conversions.isSimpleType(prop.getType())) {
                        MappingCouchbaseConverter.this.writePropertyInternal(propertyObj, target, prop, accessor);
                    } else {
                        MappingCouchbaseConverter.this.writeSimpleInternal(prop, (ConvertingPropertyAccessor<Object>)accessor, target, prop.getFieldName());
                    }
                }
            }
        });
    }

    protected void writePropertyInternal(Object source, CouchbaseDocument target, CouchbasePersistentProperty prop, ConvertingPropertyAccessor accessor) {
        if (source == null) {
            return;
        }
        String name = prop.getFieldName();
        ClassTypeInformation valueType = ClassTypeInformation.from(source.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            CouchbaseList collectionDoc = this.createCollection(MappingCouchbaseConverter.asCollection(source), (TypeInformation<?>)valueType, prop, accessor);
            this.putMaybeEncrypted(target, prop, collectionDoc, accessor);
            return;
        }
        if (valueType.isMap()) {
            CouchbaseDocument mapDoc = this.createMap((Map)source, prop);
            this.putMaybeEncrypted(target, prop, mapDoc, accessor);
            return;
        }
        if (this.conversions.hasValueConverter((PersistentProperty)prop)) {
            this.putMaybeEncrypted(target, prop, source, accessor);
            return;
        }
        if (valueType.getType().equals(Optional.class)) {
            Optional o = (Optional)source;
            this.writeSimpleInternal(o.map(s -> prop).orElse(null), (ConvertingPropertyAccessor<Object>)accessor, target, prop.getFieldName());
            return;
        }
        Optional basicTargetType = this.conversions.getCustomWriteTarget(source.getClass());
        if (basicTargetType.isPresent()) {
            basicTargetType.ifPresent(it -> target.put(name, this.conversionService.convert(source, it)));
            return;
        }
        CouchbaseDocument propertyDoc = new CouchbaseDocument();
        this.addCustomTypeKeyIfNecessary(type, source, propertyDoc);
        CouchbasePersistentEntity entity = MappingCouchbaseConverter.isSubtype(prop.getType(), source.getClass()) ? (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass()) : (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)prop);
        this.writeInternalEntity(source, propertyDoc, entity, false, prop);
        target.put(this.maybeMangle(prop), propertyDoc);
    }

    private void putMaybeEncrypted(CouchbaseDocument target, CouchbasePersistentProperty prop, Object value, ConvertingPropertyAccessor accessor) {
        if (this.conversions.hasValueConverter((PersistentProperty)prop)) {
            value = this.conversions.getPropertyValueConversions().getValueConverter((PersistentProperty)prop).write(value, (ValueConversionContext)new CouchbaseConversionContext(prop, this, accessor));
        }
        target.put(this.maybeMangle(prop), value);
    }

    private CouchbaseDocument createMap(Map<Object, Object> map, CouchbasePersistentProperty prop) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)prop, (String)"PersistentProperty must not be null!");
        return this.writeMapInternal(map, new CouchbaseDocument(), prop.getTypeInformation(), prop);
    }

    private CouchbaseDocument writeMapInternal(Map<? extends Object, Object> source, CouchbaseDocument target, TypeInformation<?> type, CouchbasePersistentProperty prop) {
        for (Map.Entry<? extends Object, Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = key.toString();
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, target, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    target.put(simpleKey, this.writeCollectionInternal(MappingCouchbaseConverter.asCollection(val), new CouchbaseList(this.conversions.getSimpleTypeHolder()), prop.getTypeInformation(), prop, this.getPropertyAccessor(val)));
                    continue;
                }
                CouchbaseDocument embeddedDoc = new CouchbaseDocument();
                this.writeInternalRoot(val, embeddedDoc, prop.getTypeInformation(), false, prop);
                target.put(simpleKey, embeddedDoc);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return target;
    }

    private CouchbaseList createCollection(Collection<?> collection, TypeInformation<?> type, CouchbasePersistentProperty prop, ConvertingPropertyAccessor accessor) {
        return this.writeCollectionInternal(collection, new CouchbaseList(this.conversions.getSimpleTypeHolder()), type, prop, accessor);
    }

    public CouchbaseList writeCollectionInternal(Collection<?> source, CouchbaseList target, TypeInformation<?> type, CouchbasePersistentProperty prop, ConvertingPropertyAccessor accessor) {
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                target.put(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                target.put(this.writeCollectionInternal(MappingCouchbaseConverter.asCollection(element), new CouchbaseList(this.conversions.getSimpleTypeHolder()), type, prop, accessor));
                continue;
            }
            CouchbaseDocument embeddedDoc = new CouchbaseDocument();
            this.writeInternalRoot(element, embeddedDoc, prop != null ? prop.getTypeInformation() : TypeInformation.of(elementType), false, prop);
            target.put(embeddedDoc);
        }
        return target;
    }

    private Object readCollection(TypeInformation<?> targetType, CouchbaseList source, Object parent) {
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class<List> collectionType = targetType.getType();
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(new HashSet(), collectionType);
        }
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        ArrayList<Object> items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, (int)source.size(false));
        TypeInformation componentType = targetType.getComponentType();
        Class rawComponentType = componentType == null ? null : componentType.getType();
        for (int i = 0; i < source.size(false); ++i) {
            Object dbObjItem = source.get(i);
            if (dbObjItem instanceof CouchbaseDocument) {
                items.add(this.read(componentType, (CouchbaseDocument)dbObjItem, parent));
                continue;
            }
            if (dbObjItem instanceof CouchbaseList) {
                items.add(this.readCollection(componentType, (CouchbaseList)dbObjItem, parent));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    private void writeSimpleInternal(Object source, CouchbaseDocument target, String key) {
        target.put(key, this.getPotentiallyConvertedSimpleWrite(source));
    }

    private void writeSimpleInternal(CouchbasePersistentProperty source, ConvertingPropertyAccessor<Object> accessor, CouchbaseDocument target, String key) {
        Object result = this.getPotentiallyConvertedSimpleWrite(source, accessor);
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            result = optional.orElse(null);
        }
        target.put(this.maybeMangle(source), result);
    }

    public Object getPotentiallyConvertedSimpleWrite(Object value) {
        return this.convertForWriteIfNeeded(value);
    }

    @Deprecated
    public Object getPotentiallyConvertedSimpleWrite(CouchbasePersistentProperty value, ConvertingPropertyAccessor<Object> accessor) {
        return this.convertForWriteIfNeeded(value, accessor, true);
    }

    public Object getPotentiallyConvertedSimpleWrite(CouchbasePersistentProperty value, ConvertingPropertyAccessor<Object> accessor, boolean processValueConverter) {
        return this.convertForWriteIfNeeded(value, accessor, processValueConverter);
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object source, CouchbaseDocument target) {
        boolean notTheSameClass;
        TypeInformation actualType = type != null ? type.getActualType() : type;
        Class reference = actualType == null ? Object.class : actualType.getType();
        boolean bl = notTheSameClass = !source.getClass().equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(source.getClass(), target);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    private <R> R readValue(Object value, TypeInformation type, Object parent) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (R)this.conversionService.convert(value, rawType);
        }
        if (value instanceof CouchbaseDocument) {
            return this.read(type, (CouchbaseDocument)value, parent);
        }
        if (value instanceof CouchbaseList) {
            return (R)this.readCollection(type, (CouchbaseList)value, parent);
        }
        return (R)this.getPotentiallyConvertedSimpleRead(value, type.getType());
    }

    public <R> R readValue(Object value, CouchbasePersistentProperty prop, Object parent, boolean noDecrypt) {
        Class rawType = prop.getType();
        if (this.conversions.hasValueConverter((PersistentProperty)prop) && !noDecrypt) {
            return (R)this.conversions.getPropertyValueConversions().getValueConverter((PersistentProperty)prop).read(value, (ValueConversionContext)new CouchbaseConversionContext(prop, this, null));
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            ClassTypeInformation ti = ClassTypeInformation.from(value.getClass());
            return (R)this.conversionService.convert(value, ti.toTypeDescriptor(), new TypeDescriptor(prop.getField()));
        }
        if (value instanceof CouchbaseDocument) {
            return this.read(prop.getTypeInformation(), (CouchbaseDocument)value, parent);
        }
        if (value instanceof CouchbaseList) {
            return (R)this.readCollection(prop.getTypeInformation(), (CouchbaseList)value, parent);
        }
        return (R)this.getPotentiallyConvertedSimpleRead(value, prop);
    }

    private ConvertingPropertyAccessor<Object> getPropertyAccessor(Object source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    private String generateId(GeneratedValue generatedValue, TreeMap<Integer, String> prefixes, TreeMap<Integer, String> suffixes, TreeMap<Integer, String> idAttributes) {
        String delimiter = generatedValue.delimiter();
        StringBuilder sb = new StringBuilder();
        boolean isAppending = false;
        if (prefixes.size() > 0) {
            this.appendKeyParts(sb, prefixes.values(), delimiter);
            isAppending = true;
        }
        if (generatedValue.strategy() == GenerationStrategy.USE_ATTRIBUTES && idAttributes.size() > 0) {
            if (isAppending) {
                sb.append(delimiter);
            }
            this.appendKeyParts(sb, idAttributes.values(), delimiter);
            isAppending = true;
        }
        if (generatedValue.strategy() == GenerationStrategy.UNIQUE) {
            if (isAppending) {
                sb.append(delimiter);
            }
            sb.append(UUID.randomUUID());
            isAppending = true;
        }
        if (suffixes.size() > 0) {
            if (isAppending) {
                sb.append(delimiter);
            }
            this.appendKeyParts(sb, suffixes.values(), delimiter);
        }
        return sb.toString();
    }

    private StringBuilder appendKeyParts(StringBuilder sb, Collection<String> values, String delimiter) {
        boolean isAppending = false;
        for (String value : values) {
            if (isAppending) {
                sb.append(delimiter);
            } else {
                isAppending = true;
            }
            sb.append(value);
        }
        return sb;
    }

    String maybeMangle(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"property");
        if (!this.conversions.hasValueConverter(property)) {
            return ((CouchbasePersistentProperty)property).getFieldName();
        }
        PropertyValueConverter propertyValueConverter = this.conversions.getPropertyValueConversions().getValueConverter((PersistentProperty)((CouchbasePersistentProperty)property));
        CryptoManager cryptoManager = propertyValueConverter != null && propertyValueConverter instanceof CryptoConverter ? ((CryptoConverter)propertyValueConverter).cryptoManager() : null;
        String fname = ((CouchbasePersistentProperty)property).getFieldName();
        return cryptoManager != null ? cryptoManager.mangle(fname) : fname;
    }

    private class CouchbasePropertyValueProvider
    implements PropertyValueProvider<CouchbasePersistentProperty> {
        private final CouchbaseDocument source;
        private final SpELExpressionEvaluator evaluator;
        private final Object parent;
        private final PersistentEntity entity;

        public CouchbasePropertyValueProvider(CouchbaseDocument source, SpELContext factory, Object parent, PersistentEntity entity) {
            this(source, new DefaultSpELExpressionEvaluator((Object)source, factory), parent, entity);
        }

        public CouchbasePropertyValueProvider(CouchbaseDocument source, DefaultSpELExpressionEvaluator evaluator, Object parent, PersistentEntity entity) {
            Assert.notNull((Object)source, (String)"CouchbaseDocument must not be null!");
            Assert.notNull((Object)evaluator, (String)"DefaultSpELExpressionEvaluator must not be null!");
            this.source = source;
            this.evaluator = evaluator;
            this.parent = parent;
            this.entity = entity;
        }

        public <R> R getPropertyValue(CouchbasePersistentProperty property) {
            String expression = property.getSpelExpression();
            String maybeFieldName = MappingCouchbaseConverter.this.maybeMangle(property);
            Object value = expression != null ? this.evaluator.evaluate(expression) : this.source.get(maybeFieldName);
            boolean noDecrypt = false;
            if (property.findAnnotation(Encrypted.class) != null) {
                if (value == null && !maybeFieldName.equals(property.getFieldName()) && ((Encrypted)property.findAnnotation(Encrypted.class)).migration().equals((Object)Encrypted.Migration.FROM_UNENCRYPTED)) {
                    value = this.source.get(property.getFieldName());
                    noDecrypt = true;
                } else if (!(value == null || value instanceof CouchbaseDocument && ((CouchbaseDocument)value).containsKey("kid"))) {
                    noDecrypt = true;
                    throw new RuntimeException("should have been encrypted, but is not " + maybeFieldName);
                }
            }
            if (property == this.entity.getIdProperty() && this.parent == null) {
                return MappingCouchbaseConverter.this.readValue(this.source.getId(), property.getTypeInformation(), this.source);
            }
            if (value == null) {
                return null;
            }
            return MappingCouchbaseConverter.this.readValue(value, property, this.source, noDecrypt);
        }
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<CouchbasePersistentProperty> {
        private final Object parent;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<CouchbasePersistentProperty> delegate, Object parent) {
            super(evaluator, conversionService, delegate);
            this.parent = parent;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, Parameter<T, CouchbasePersistentProperty> parameter) {
            return (T)MappingCouchbaseConverter.this.readValue(object, parameter.getType(), this.parent);
        }
    }
}

