/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.Base64Utils;

public final class OtherConverters {
    private OtherConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(UuidToString.INSTANCE);
        converters.add(StringToUuid.INSTANCE);
        converters.add(BigIntegerToString.INSTANCE);
        converters.add(StringToBigInteger.INSTANCE);
        converters.add(BigDecimalToString.INSTANCE);
        converters.add(StringToBigDecimal.INSTANCE);
        converters.add(ByteArrayToString.INSTANCE);
        converters.add(StringToByteArray.INSTANCE);
        converters.add(CharArrayToString.INSTANCE);
        converters.add(StringToCharArray.INSTANCE);
        converters.add(ClassToString.INSTANCE);
        converters.add(StringToClass.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum UuidToString implements Converter<UUID, String>
    {
        INSTANCE;


        public String convert(UUID source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToUuid implements Converter<String, UUID>
    {
        INSTANCE;


        public UUID convert(String source) {
            return source == null ? null : UUID.fromString(source);
        }
    }

    @WritingConverter
    public static enum BigIntegerToString implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigInteger implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return source == null ? null : new BigInteger(source);
        }
    }

    @WritingConverter
    public static enum BigDecimalToString implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigDecimal implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return source == null ? null : new BigDecimal(source);
        }
    }

    @WritingConverter
    public static enum ByteArrayToString implements Converter<byte[], String>
    {
        INSTANCE;


        public String convert(byte[] source) {
            return source == null ? null : Base64Utils.encodeToString((byte[])source);
        }
    }

    @ReadingConverter
    public static enum StringToByteArray implements Converter<String, byte[]>
    {
        INSTANCE;


        public byte[] convert(String source) {
            return source == null ? null : Base64Utils.decode((byte[])source.getBytes(StandardCharsets.UTF_8));
        }
    }

    @WritingConverter
    public static enum CharArrayToString implements Converter<char[], String>
    {
        INSTANCE;


        public String convert(char[] source) {
            return source == null ? null : new String(source);
        }
    }

    @ReadingConverter
    public static enum StringToCharArray implements Converter<String, char[]>
    {
        INSTANCE;


        public char[] convert(String source) {
            return source == null ? null : source.toCharArray();
        }
    }

    @WritingConverter
    public static enum ClassToString implements Converter<Class<?>, String>
    {
        INSTANCE;


        public String convert(Class<?> source) {
            return source == null ? null : source.getClass().getName();
        }
    }

    @ReadingConverter
    public static enum StringToClass implements Converter<String, Class<?>>
    {
        INSTANCE;


        public Class<?> convert(String source) {
            try {
                return source == null ? null : Class.forName(source);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

