/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseParameterAccessor;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractCouchbaseQueryBase<CouchbaseOperationsType>
implements RepositoryQuery {
    private final CouchbaseQueryMethod method;
    private final CouchbaseOperationsType operations;
    private final EntityInstantiators instantiators;
    private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> findOperationWithProjection;
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public AbstractCouchbaseQueryBase(CouchbaseQueryMethod method, CouchbaseOperationsType operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)method), (String)"CouchbaseQueryMethod must not be null!");
        Assert.notNull(operations, (String)"ReactiveCouchbaseOperations must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getJavaType();
        this.findOperationWithProjection = operations instanceof CouchbaseOperations ? ((CouchbaseOperations)operations).findByQuery(type) : null;
    }

    public CouchbaseQueryMethod getQueryMethod() {
        return this.method;
    }

    public CouchbaseOperationsType getOperations() {
        return this.operations;
    }

    EntityInstantiators getInstantiators() {
        return this.instantiators;
    }

    public Object execute(Object[] parameters) {
        ReactiveCouchbaseParameterAccessor accessor = new ReactiveCouchbaseParameterAccessor(this.getQueryMethod(), parameters);
        return this.method.hasReactiveWrapperParameter() ? accessor.resolveParameters().flatMapMany(this::executeDeferred) : this.execute(accessor);
    }

    private Publisher<Object> executeDeferred(ReactiveCouchbaseParameterAccessor parameterAccessor) {
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute(parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute(parameterAccessor));
    }

    private Object execute(ParametersParameterAccessor parameterAccessor) {
        ClassTypeInformation returnType = ClassTypeInformation.from((Class)this.method.getResultProcessor().getReturnedType().getReturnedType());
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        if (typeToRead == null && returnType.getComponentType() != null) {
            typeToRead = returnType.getComponentType().getType();
        }
        return this.doExecute(this.getQueryMethod(), processor, parameterAccessor, typeToRead);
    }

    protected abstract Object doExecute(CouchbaseQueryMethod var1, ResultProcessor var2, ParametersParameterAccessor var3, @Nullable Class<?> var4);

    Query applyQueryMetaAttributesIfPresent(Query query, Class<?> typeToRead) {
        query.setMeta(this.getQueryMethod(), typeToRead);
        return query;
    }

    protected abstract Query createCountQuery(ParametersParameterAccessor var1);

    protected abstract Query createQuery(ParametersParameterAccessor var1);

    protected boolean isCountQuery() {
        return this.getQueryMethod().isCountQuery();
    }

    protected boolean isExistsQuery() {
        return this.getQueryMethod().isExistsQuery();
    }

    protected boolean isDeleteQuery() {
        return this.getQueryMethod().isDeleteQuery();
    }

    boolean isTailable(CouchbaseQueryMethod method) {
        return false;
    }

    protected abstract boolean isLimiting();

    static boolean hasAmbiguousProjectionFlags(boolean isCountQuery, boolean isExistsQuery, boolean isDeleteQuery) {
        return AbstractCouchbaseQueryBase.multipleOf(isCountQuery, isExistsQuery, isDeleteQuery);
    }

    static boolean multipleOf(boolean ... values) {
        int count = 0;
        for (boolean value : values) {
            if (!value) continue;
            if (count != 0) {
                return true;
            }
            ++count;
        }
        return false;
    }
}

