/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.ReactiveUpsertByIdOperation;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveUpsertByIdOperationSupport
implements ReactiveUpsertByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveUpsertByIdOperationSupport.class);

    public ReactiveUpsertByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveUpsertByIdOperation.ReactiveUpsertById<T> upsertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveUpsertByIdSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, OptionsBuilder.getPersistTo(domainType), OptionsBuilder.getReplicateTo(domainType), OptionsBuilder.getDurabilityLevel(domainType), null, this.template.support());
    }

    static class ReactiveUpsertByIdSupport<T>
    implements ReactiveUpsertByIdOperation.ReactiveUpsertById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final UpsertOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveTemplateSupport support;

        ReactiveUpsertByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, UpsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.support = support;
        }

        @Override
        public Mono<T> one(T object) {
            PseudoArgs<UpsertOptions> pArgs = new PseudoArgs<UpsertOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("upsertById object={} {}", object, pArgs);
            }
            Mono reactiveEntity = TransactionalSupport.verifyNotInTransaction("upsertById").then(this.support.encodeEntity(object)).flatMap(converted -> Mono.just((Object)this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection())).flatMap(collection -> collection.reactive().upsert(converted.getId().toString(), converted.export(), this.buildUpsertOptions((UpsertOptions)pArgs.getOptions(), (CouchbaseDocument)converted)).flatMap(result -> this.support.applyResult(object, (CouchbaseDocument)converted, converted.getId(), result.cas(), null, null))));
            return reactiveEntity.onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        private UpsertOptions buildUpsertOptions(UpsertOptions options, CouchbaseDocument doc) {
            return OptionsBuilder.buildUpsertOptions(options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, doc);
        }

        @Override
        public ReactiveUpsertByIdOperation.TerminatingUpsertById<T> withOptions(UpsertOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdWithDurability<T> inCollection(String collection) {
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdInCollection<T> inScope(String scope) {
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry, this.support);
        }
    }
}

