/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.couchbase.core.mapping.Expiry;
import org.springframework.data.couchbase.repository.ScanConsistency;

@Persistent
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Expiry
@ScanConsistency
public @interface Document {
    @AliasFor(annotation=Expiry.class, attribute="expiry")
    public int expiry() default 0;

    @AliasFor(annotation=Expiry.class, attribute="expiryExpression")
    public String expiryExpression() default "";

    @AliasFor(annotation=Expiry.class, attribute="expiryUnit")
    public TimeUnit expiryUnit() default TimeUnit.SECONDS;

    public boolean touchOnRead() default false;

    @AliasFor(annotation=ScanConsistency.class, attribute="query")
    public QueryScanConsistency queryScanConsistency() default QueryScanConsistency.NOT_BOUNDED;

    public PersistTo persistTo() default PersistTo.NONE;

    public ReplicateTo replicateTo() default ReplicateTo.NONE;

    public DurabilityLevel durabilityLevel() default DurabilityLevel.NONE;
}

