/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValueModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.util.Base64Utils;

public final class OtherConverters {
    private OtherConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(UuidToString.INSTANCE);
        converters.add(StringToUuid.INSTANCE);
        converters.add(BigIntegerToString.INSTANCE);
        converters.add(StringToBigInteger.INSTANCE);
        converters.add(BigDecimalToString.INSTANCE);
        converters.add(StringToBigDecimal.INSTANCE);
        converters.add(ByteArrayToString.INSTANCE);
        converters.add(StringToByteArray.INSTANCE);
        converters.add(CharArrayToString.INSTANCE);
        converters.add(StringToCharArray.INSTANCE);
        converters.add(ClassToString.INSTANCE);
        converters.add(StringToClass.INSTANCE);
        converters.add(MapToJsonNode.INSTANCE);
        converters.add(JsonNodeToMap.INSTANCE);
        converters.add(JsonObjectToMap.INSTANCE);
        converters.add(MapToJsonObject.INSTANCE);
        converters.add(JsonArrayToCouchbaseList.INSTANCE);
        converters.add(CouchbaseListToJsonArray.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum UuidToString implements Converter<UUID, String>
    {
        INSTANCE;


        public String convert(UUID source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToUuid implements Converter<String, UUID>
    {
        INSTANCE;


        public UUID convert(String source) {
            return source == null ? null : UUID.fromString(source);
        }
    }

    @WritingConverter
    public static enum BigIntegerToString implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigInteger implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return source == null ? null : new BigInteger(source);
        }
    }

    @WritingConverter
    public static enum BigDecimalToString implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigDecimal implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return source == null ? null : new BigDecimal(source);
        }
    }

    @WritingConverter
    public static enum ByteArrayToString implements Converter<byte[], String>
    {
        INSTANCE;


        public String convert(byte[] source) {
            return source == null ? null : Base64Utils.encodeToString((byte[])source);
        }
    }

    @ReadingConverter
    public static enum StringToByteArray implements Converter<String, byte[]>
    {
        INSTANCE;


        public byte[] convert(String source) {
            return source == null ? null : Base64Utils.decode((byte[])source.getBytes(StandardCharsets.UTF_8));
        }
    }

    @WritingConverter
    public static enum CharArrayToString implements Converter<char[], String>
    {
        INSTANCE;


        public String convert(char[] source) {
            return source == null ? null : new String(source);
        }
    }

    @ReadingConverter
    public static enum StringToCharArray implements Converter<String, char[]>
    {
        INSTANCE;


        public char[] convert(String source) {
            return source == null ? null : source.toCharArray();
        }
    }

    @WritingConverter
    public static enum ClassToString implements Converter<Class<?>, String>
    {
        INSTANCE;


        public String convert(Class<?> source) {
            return source == null ? null : source.getClass().getName();
        }
    }

    @ReadingConverter
    public static enum StringToClass implements Converter<String, Class<?>>
    {
        INSTANCE;


        public Class<?> convert(String source) {
            try {
                return source == null ? null : Class.forName(source);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ReadingConverter
    public static enum MapToJsonNode implements Converter<CouchbaseDocument, JsonNode>
    {
        INSTANCE;

        static ObjectMapper mapper;

        public JsonNode convert(CouchbaseDocument source) {
            if (source == null) {
                return null;
            }
            return mapper.valueToTree(source.export());
        }

        static {
            mapper = new ObjectMapper().registerModule((Module)new JsonValueModule());
        }
    }

    @WritingConverter
    public static enum JsonNodeToMap implements Converter<JsonNode, CouchbaseDocument>
    {
        INSTANCE;

        static ObjectMapper mapper;

        public CouchbaseDocument convert(JsonNode source) {
            if (source == null) {
                return null;
            }
            return new CouchbaseDocument().setContent((Map)mapper.convertValue((Object)source, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }

        static {
            mapper = new ObjectMapper().registerModule((Module)new JsonValueModule());
        }
    }

    @WritingConverter
    public static enum JsonObjectToMap implements Converter<JsonObject, CouchbaseDocument>
    {
        INSTANCE;


        public CouchbaseDocument convert(JsonObject source) {
            if (source == null) {
                return null;
            }
            return new CouchbaseDocument().setContent(source);
        }
    }

    @ReadingConverter
    public static enum MapToJsonObject implements Converter<CouchbaseDocument, JsonObject>
    {
        INSTANCE;

        static ObjectMapper mapper;

        public JsonObject convert(CouchbaseDocument source) {
            if (source == null) {
                return null;
            }
            return JsonObject.from(source.export());
        }

        static {
            mapper = new ObjectMapper();
        }
    }

    @WritingConverter
    public static enum JsonArrayToCouchbaseList implements Converter<JsonArray, CouchbaseList>
    {
        INSTANCE;


        public CouchbaseList convert(JsonArray source) {
            if (source == null) {
                return null;
            }
            return new CouchbaseList(source.toList());
        }
    }

    @ReadingConverter
    public static enum CouchbaseListToJsonArray implements Converter<CouchbaseList, JsonArray>
    {
        INSTANCE;

        static ObjectMapper mapper;

        public JsonArray convert(CouchbaseList source) {
            if (source == null) {
                return null;
            }
            return JsonArray.from(source.export());
        }

        static {
            mapper = new ObjectMapper();
        }
    }

    @WritingConverter
    public static class EnumToObject
    implements Converter<Enum<?>, Object> {
        private final ObjectMapper objectMapper;
        private static final JsonFactory factory = new JsonFactory();

        public EnumToObject(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Object convert(Enum<?> source) {
            try (StringWriter writer = new StringWriter();){
                Object object;
                block21: {
                    String s;
                    JsonGenerator generator;
                    block19: {
                        Object object2;
                        block20: {
                            block17: {
                                Object object3;
                                block18: {
                                    generator = factory.createGenerator((Writer)writer);
                                    try {
                                        this.objectMapper.writeValue(generator, source);
                                        s = ((Object)writer).toString();
                                        if (s == null || !s.startsWith("\"")) break block17;
                                        object3 = this.objectMapper.readValue(s, String.class);
                                        if (generator == null) break block18;
                                    }
                                    catch (Throwable throwable) {
                                        if (generator != null) {
                                            try {
                                                generator.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    generator.close();
                                }
                                return object3;
                            }
                            if (!"true".equals(s) && !"false".equals(s)) break block19;
                            object2 = this.objectMapper.readValue(s, Boolean.class);
                            if (generator == null) break block20;
                            generator.close();
                        }
                        return object2;
                    }
                    object = this.objectMapper.readValue(s, Number.class);
                    if (generator == null) break block21;
                    generator.close();
                }
                return object;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

