/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperationSupport;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.util.Assert;

public class ExecutableRemoveByQueryOperationSupport
implements ExecutableRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final CouchbaseTemplate template;

    public ExecutableRemoveByQueryOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ExecutableRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, null, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null);
    }

    static class ExecutableRemoveByQuerySupport<T>
    implements ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final ReactiveRemoveByQueryOperationSupport.ReactiveRemoveByQuerySupport<T> reactiveSupport;
        private final QueryScanConsistency scanConsistency;
        private final String scope;
        private final String collection;
        private final QueryOptions options;

        ExecutableRemoveByQuerySupport(CouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency, String scope, String collection, QueryOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.reactiveSupport = new ReactiveRemoveByQueryOperationSupport.ReactiveRemoveByQuerySupport<T>(template.reactive(), domainType, query, scanConsistency, scope, collection, options);
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
        }

        @Override
        public List<RemoveResult> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        @Deprecated
        public ExecutableRemoveByQueryOperation.RemoveByQueryInScope<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryWithConsistency<T> inCollection(String collection) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, this.scope, collection != null ? collection : this.collection, this.options);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryWithQuery<T> withOptions(QueryOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, this.scope, this.collection, options);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryInCollection<T> inScope(String scope) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, scope != null ? scope : this.scope, this.collection, this.options);
        }
    }
}

