/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.core.encryption.CryptoManager;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.couchbase.core.convert.CryptoConverter;
import org.springframework.data.couchbase.core.convert.JsonValueConverter;
import org.springframework.data.mapping.PersistentProperty;

public class CouchbasePropertyValueConverterFactory
implements PropertyValueConverterFactory {
    private final CryptoManager cryptoManager;
    private final ObjectMapper objectMapper;
    private final Map<Class<? extends Annotation>, Class<?>> annotationToConverterMap;
    protected static final Map<Class<?>, Optional<PropertyValueConverter<?, ?, ?>>> converterCacheForType = new ConcurrentHashMap();

    public CouchbasePropertyValueConverterFactory(CryptoManager cryptoManager, Map<Class<? extends Annotation>, Class<?>> annotationToConverterMap, ObjectMapper objectMapper) {
        this.cryptoManager = cryptoManager;
        this.annotationToConverterMap = annotationToConverterMap;
        this.objectMapper = objectMapper;
    }

    public <DV, SV, P extends ValueConversionContext<?>> PropertyValueConverter<DV, SV, P> getConverter(PersistentProperty<?> property) {
        PropertyValueConverter valueConverter = super.getConverter(property);
        if (valueConverter != null) {
            return valueConverter;
        }
        for (Annotation ann : property.getField().getAnnotations()) {
            Class<?> converterClass = this.converterFromFieldAnnotation(ann);
            if (converterClass == null) continue;
            return this.getConverter(converterClass, property);
        }
        if (property.getType().isEnum()) {
            return null;
        }
        return converterCacheForType.computeIfAbsent(property.getType(), p -> Optional.ofNullable(this.maybeTypePropertyConverter(property))).orElse(null);
    }

    private Class<?> converterFromFieldAnnotation(Annotation ann) {
        return this.annotationToConverterMap.get(ann.annotationType());
    }

    <DV, SV, P extends ValueConversionContext<?>> PropertyValueConverter<DV, SV, P> maybeTypePropertyConverter(PersistentProperty<?> property) {
        Class type = property.getType();
        Method jsonValueMethod = null;
        for (Method m : type.getDeclaredMethods()) {
            Class<?> jsonValueConverterClass;
            JsonValue jsonValueAnn = m.getAnnotation(JsonValue.class);
            if (jsonValueAnn == null || !jsonValueAnn.value() || (jsonValueConverterClass = this.converterFromFieldAnnotation((Annotation)jsonValueAnn)) == null) continue;
            jsonValueMethod = m;
            jsonValueMethod.setAccessible(true);
            JsonValueConverter.valueMethodCache.put(type, jsonValueMethod);
            Constructor<?> jsonCreatorMethod = null;
            for (Constructor<?> c : type.getConstructors()) {
                JsonCreator jsonCreatorAnn = c.getAnnotation(JsonCreator.class);
                if (jsonCreatorAnn == null || jsonCreatorAnn.mode().equals((Object)JsonCreator.Mode.DISABLED)) continue;
                jsonCreatorMethod = c;
                jsonCreatorMethod.setAccessible(true);
                JsonValueConverter.creatorMethodCache.put(type, jsonCreatorMethod);
                break;
            }
            return this.getConverter(jsonValueConverterClass, property);
        }
        return null;
    }

    public <DV, SV, P extends ValueConversionContext<?>> PropertyValueConverter<DV, SV, P> getConverter(Class<? extends PropertyValueConverter<DV, SV, P>> converterType) {
        return this.getConverter(converterType, null);
    }

    public <DV, SV, P extends ValueConversionContext<?>> PropertyValueConverter<DV, SV, P> getConverter(Class<? extends PropertyValueConverter<DV, SV, P>> converterType, PersistentProperty<?> property) {
        if (CryptoConverter.class.isAssignableFrom(converterType)) {
            return new CryptoConverter(this.cryptoManager, this.objectMapper);
        }
        if (property != null) {
            try {
                Constructor<? extends PropertyValueConverter<DV, SV, P>> constructor = converterType.getConstructor(PersistentProperty.class);
                return (PropertyValueConverter)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{property});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return (PropertyValueConverter)BeanUtils.instantiateClass(converterType);
    }
}

