/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.transaction;

import com.couchbase.client.core.annotation.Stability;
import java.util.Optional;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import reactor.core.publisher.Mono;

@Stability.Internal
public class CouchbaseResourceOwner {
    private static final ThreadLocal<CouchbaseResourceHolder> marker = new ThreadLocal();

    public static void set(CouchbaseResourceHolder toInject) {
        if (marker.get() != null) {
            throw new IllegalStateException("Trying to set resource holder when already inside a transaction - likely an internal bug, please report it");
        }
        marker.set(toInject);
    }

    public static void clear() {
        marker.remove();
    }

    public static Mono<Optional<CouchbaseResourceHolder>> get() {
        return Mono.deferContextual(ctx -> {
            CouchbaseResourceHolder fromReactive;
            CouchbaseResourceHolder fromThreadLocal = marker.get();
            CouchbaseResourceHolder couchbaseResourceHolder = fromReactive = ctx.hasKey(CouchbaseResourceHolder.class) ? (CouchbaseResourceHolder)((Object)((Object)ctx.get(CouchbaseResourceHolder.class))) : null;
            if (fromThreadLocal != null) {
                return Mono.just(Optional.of(fromThreadLocal));
            }
            return fromReactive != null ? Mono.just(Optional.of(fromReactive)) : Mono.just(Optional.empty());
        });
    }
}

