/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.Collection;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.lang.reflect.Field;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseTemplateSupport;
import org.springframework.data.couchbase.core.ExecutableExistsByIdOperation;
import org.springframework.data.couchbase.core.ExecutableExistsByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.ExecutableFindByAnalyticsOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindByIdOperation;
import org.springframework.data.couchbase.core.ExecutableFindByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindFromReplicasByIdOperation;
import org.springframework.data.couchbase.core.ExecutableFindFromReplicasByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableInsertByIdOperation;
import org.springframework.data.couchbase.core.ExecutableInsertByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableMutateInByIdOperation;
import org.springframework.data.couchbase.core.ExecutableMutateInByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableRangeScanOperation;
import org.springframework.data.couchbase.core.ExecutableRangeScanOperationSupport;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperation;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperationSupport;
import org.springframework.data.couchbase.core.ExecutableReplaceByIdOperation;
import org.springframework.data.couchbase.core.ExecutableReplaceByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableUpsertByIdOperation;
import org.springframework.data.couchbase.core.ExecutableUpsertByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.TemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.index.CouchbasePersistentEntityIndexCreator;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class CouchbaseTemplate
implements CouchbaseOperations,
ApplicationContextAware {
    private final CouchbaseClientFactory clientFactory;
    private final CouchbaseConverter converter;
    private final CouchbaseTemplateSupport templateSupport;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final ReactiveCouchbaseTemplate reactiveCouchbaseTemplate;
    private final QueryScanConsistency scanConsistency;
    private @Nullable CouchbasePersistentEntityIndexCreator indexCreator;

    public CouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter) {
        this(clientFactory, converter, new JacksonTranslationService());
    }

    public CouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter, TranslationService translationService) {
        this(clientFactory, converter, translationService, null);
    }

    public CouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter, TranslationService translationService, QueryScanConsistency scanConsistency) {
        CouchbaseMappingContext cmc;
        this.clientFactory = clientFactory;
        this.converter = converter;
        this.templateSupport = new CouchbaseTemplateSupport(this, converter, translationService);
        this.reactiveCouchbaseTemplate = new ReactiveCouchbaseTemplate(clientFactory, converter, translationService, scanConsistency);
        this.scanConsistency = scanConsistency;
        this.mappingContext = this.converter.getMappingContext();
        if (this.mappingContext instanceof CouchbaseMappingContext && (cmc = (CouchbaseMappingContext)this.mappingContext).isAutoIndexCreation()) {
            this.indexCreator = new CouchbasePersistentEntityIndexCreator(cmc, this);
        }
    }

    @Override
    public <T> T save(T entity, String ... scopeAndCollection) {
        return this.save(entity, (CommonOptions<?>)null, scopeAndCollection);
    }

    @Override
    public <T> T save(T entity, CommonOptions<?> options, String ... scopeAndCollection) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        String scope = scopeAndCollection.length > 0 ? scopeAndCollection[0] : null;
        String collection = scopeAndCollection.length > 1 ? scopeAndCollection[1] : null;
        CouchbasePersistentEntity mapperEntity = (CouchbasePersistentEntity)this.getConverter().getMappingContext().getPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)mapperEntity.getVersionProperty();
        boolean versionPresent = versionProperty != null;
        Long version = versionProperty == null || versionProperty.getField() == null ? null : (Long)ReflectionUtils.getField((Field)versionProperty.getField(), entity);
        boolean existingDocument = version != null && version > 0L;
        Class<?> clazz = entity.getClass();
        if (!versionPresent) {
            return (T)TransactionalSupport.checkForTransactionInThreadLocalStorage().map(ctx -> {
                if (ctx.isPresent()) {
                    return this.insertById(clazz).inScope(scope).inCollection(collection).withOptions((InsertOptions)options).one(entity);
                }
                return this.upsertById(clazz).inScope(scope).inCollection(collection).withOptions((UpsertOptions)options).one(entity);
            }).block();
        }
        if (existingDocument) {
            return this.replaceById(clazz).inScope(scope).inCollection(collection).withOptions((ReplaceOptions)options).one(entity);
        }
        return this.insertById(clazz).inScope(scope).inCollection(collection).withOptions((InsertOptions)options).one(entity);
    }

    @Override
    public <T> Long count(Query query, Class<T> domainType) {
        return this.findByQuery(domainType).matching(query).count();
    }

    @Override
    public <T> ExecutableUpsertByIdOperation.ExecutableUpsertById<T> upsertById(Class<T> domainType) {
        return new ExecutableUpsertByIdOperationSupport(this).upsertById(domainType);
    }

    @Override
    public <T> ExecutableMutateInByIdOperation.ExecutableMutateInById<T> mutateInById(Class<T> domainType) {
        return new ExecutableMutateInByIdOperationSupport(this).mutateInById(domainType);
    }

    @Override
    public <T> ExecutableInsertByIdOperation.ExecutableInsertById<T> insertById(Class<T> domainType) {
        return new ExecutableInsertByIdOperationSupport(this).insertById(domainType);
    }

    @Override
    public <T> ExecutableReplaceByIdOperation.ExecutableReplaceById<T> replaceById(Class<T> domainType) {
        return new ExecutableReplaceByIdOperationSupport(this).replaceById(domainType);
    }

    @Override
    public <T> ExecutableFindByIdOperation.ExecutableFindById<T> findById(Class<T> domainType) {
        return new ExecutableFindByIdOperationSupport(this).findById(domainType);
    }

    @Override
    public <T> ExecutableFindFromReplicasByIdOperation.ExecutableFindFromReplicasById<T> findFromReplicasById(Class<T> domainType) {
        return new ExecutableFindFromReplicasByIdOperationSupport(this).findFromReplicasById(domainType);
    }

    @Override
    public <T> ExecutableFindByQueryOperation.ExecutableFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ExecutableFindByQueryOperationSupport(this).findByQuery(domainType);
    }

    @Override
    public <T> ExecutableFindByAnalyticsOperation.ExecutableFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ExecutableFindByAnalyticsOperationSupport(this).findByAnalytics(domainType);
    }

    @Override
    @Deprecated
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById() {
        return this.removeById(null);
    }

    @Override
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById(Class<?> domainType) {
        return new ExecutableRemoveByIdOperationSupport(this).removeById(domainType);
    }

    @Override
    @Deprecated
    public ExecutableExistsByIdOperation.ExecutableExistsById existsById() {
        return this.existsById(null);
    }

    @Override
    public ExecutableExistsByIdOperation.ExecutableExistsById existsById(Class<?> domainType) {
        return new ExecutableExistsByIdOperationSupport(this).existsById(domainType);
    }

    @Override
    public <T> ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ExecutableRemoveByQueryOperationSupport(this).removeByQuery(domainType);
    }

    @Override
    public <T> ExecutableRangeScanOperation.ExecutableRangeScan<T> rangeScan(Class<T> domainType) {
        return new ExecutableRangeScanOperationSupport(this).rangeScan(domainType);
    }

    @Override
    public String getBucketName() {
        return this.clientFactory.getBucket().name();
    }

    @Override
    public String getScopeName() {
        return this.clientFactory.getScope().name();
    }

    @Override
    public CouchbaseClientFactory getCouchbaseClientFactory() {
        return this.clientFactory;
    }

    @Override
    public QueryScanConsistency getConsistency() {
        return this.scanConsistency;
    }

    public Collection getCollection(String collectionName) {
        return this.clientFactory.getCollection(collectionName);
    }

    @Override
    public CouchbaseConverter getConverter() {
        return this.converter;
    }

    public ReactiveCouchbaseTemplate reactive() {
        return this.reactiveCouchbaseTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.prepareIndexCreator(applicationContext);
        this.templateSupport.setApplicationContext(applicationContext);
        this.reactiveCouchbaseTemplate.setApplicationContext(applicationContext);
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(CouchbasePersistentEntityIndexCreator.class)) {
            CouchbasePersistentEntityIndexCreator creatorBean = (CouchbasePersistentEntityIndexCreator)context.getBean(creator, CouchbasePersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext && this.indexCreator != null) {
            ((ConfigurableApplicationContext)context).addApplicationListener((ApplicationListener)this.indexCreator);
            if (this.mappingContext instanceof CouchbaseMappingContext) {
                CouchbaseMappingContext cmc = (CouchbaseMappingContext)this.mappingContext;
                cmc.setIndexCreator(this.indexCreator);
            }
        }
    }

    public TemplateSupport support() {
        return this.templateSupport;
    }
}

