/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import java.time.Instant;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.couchbase.core.AbstractTemplateSupport;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.TemplateSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.event.AfterConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.util.Assert;

class CouchbaseTemplateSupport
extends AbstractTemplateSupport
implements ApplicationContextAware,
TemplateSupport {
    private final CouchbaseTemplate template;
    private EntityCallbacks entityCallbacks;

    public CouchbaseTemplateSupport(CouchbaseTemplate template, CouchbaseConverter converter, TranslationService translationService) {
        super(template.reactive(), converter, translationService);
        this.template = template;
    }

    @Override
    public CouchbaseDocument encodeEntity(Object entityToEncode) {
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(entityToEncode));
        Object maybeNewEntity = this.maybeCallBeforeConvert(entityToEncode, "");
        CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(maybeNewEntity, converted);
        this.maybeCallAfterConvert(entityToEncode, converted, "");
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(entityToEncode, converted));
        return converted;
    }

    @Override
    public <T> T decodeEntity(Object id, String source, Long cas, Instant expiryTime, Class<T> entityClass, String scope, String collection, Object txHolder, CouchbaseResourceHolder holder) {
        return this.decodeEntityBase(id, source, cas, expiryTime, entityClass, scope, collection, txHolder, holder);
    }

    @Override
    public <T> T applyResult(T entity, CouchbaseDocument converted, Object id, long cas, Object txResultHolder, CouchbaseResourceHolder holder) {
        return this.applyResultBase(entity, converted, id, cas, txResultHolder, holder);
    }

    @Override
    public <T> Integer getTxResultHolder(T source) {
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    protected <T> T maybeCallBeforeConvert(T object, String collection) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{collection});
        }
        LOG.info("maybeCallBeforeConvert called, but CouchbaseTemplate not initialized with applicationContext");
        return object;
    }

    protected <T> T maybeCallAfterConvert(T object, CouchbaseDocument document, String collection) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{document, collection});
        }
        LOG.info("maybeCallAfterConvert called, but CouchbaseTemplate not initialized with applicationContext");
        return object;
    }

    @Override
    ReactiveCouchbaseTemplate getReactiveTemplate() {
        return this.template.reactive();
    }
}

