/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsScanConsistency;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveFindByAnalyticsOperationSupport;
import org.springframework.data.couchbase.core.query.AnalyticsQuery;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.util.Assert;

public class ExecutableFindByAnalyticsOperationSupport
implements ExecutableFindByAnalyticsOperation {
    private static final AnalyticsQuery ALL_QUERY = new AnalyticsQuery();
    private final CouchbaseTemplate template;

    public ExecutableFindByAnalyticsOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByAnalyticsOperation.ExecutableFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ExecutableFindByAnalyticsSupport<T>(this.template, domainType, domainType, ALL_QUERY, null, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null);
    }

    static class ExecutableFindByAnalyticsSupport<T>
    implements ExecutableFindByAnalyticsOperation.ExecutableFindByAnalytics<T> {
        private final CouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final ReactiveFindByAnalyticsOperationSupport.ReactiveFindByAnalyticsSupport<T> reactiveSupport;
        private final AnalyticsQuery query;
        private final AnalyticsScanConsistency scanConsistency;
        private final String scope;
        private final String collection;
        private final AnalyticsOptions options;

        ExecutableFindByAnalyticsSupport(CouchbaseTemplate template, Class<?> domainType, Class<T> returnType, AnalyticsQuery query, AnalyticsScanConsistency scanConsistency, String scope, String collection, AnalyticsOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.reactiveSupport = new ReactiveFindByAnalyticsOperationSupport.ReactiveFindByAnalyticsSupport<T>(template.reactive(), domainType, returnType, query, scanConsistency, scope, collection, options, new NonReactiveSupportWrapper(template.support()));
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
        }

        @Override
        public T oneValue() {
            return (T)this.reactiveSupport.one().block();
        }

        @Override
        public T firstValue() {
            return (T)this.reactiveSupport.first().block();
        }

        @Override
        public List<T> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableFindByAnalyticsOperation.TerminatingFindByAnalytics<T> matching(AnalyticsQuery query) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, query, this.scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> withOptions(AnalyticsOptions options) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, options != null ? options : this.options);
        }

        @Override
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsInCollection<T> inScope(String scope) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, scope != null ? scope : this.scope, this.collection, this.options);
        }

        @Override
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsWithConsistency<T> inCollection(String collection) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, collection != null ? collection : this.collection, this.options);
        }

        @Override
        @Deprecated
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> consistentWith(AnalyticsScanConsistency scanConsistency) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsWithConsistency<T> withConsistency(AnalyticsScanConsistency scanConsistency) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public <R> ExecutableFindByAnalyticsOperation.FindByAnalyticsWithConsistency<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"returnType must not be null!");
            return new ExecutableFindByAnalyticsSupport<R>(this.template, this.domainType, returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public Stream<T> stream() {
            return this.reactiveSupport.all().toStream();
        }

        @Override
        public long count() {
            return (Long)this.reactiveSupport.count().block();
        }

        @Override
        public boolean exists() {
            return this.count() > 0L;
        }
    }
}

