/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import java.time.Instant;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TemplateSupport;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import reactor.core.publisher.Mono;

public class NonReactiveSupportWrapper
implements ReactiveTemplateSupport {
    private final TemplateSupport support;

    public NonReactiveSupportWrapper(TemplateSupport support) {
        this.support = support;
    }

    @Override
    public Mono<CouchbaseDocument> encodeEntity(Object entityToEncode) {
        return Mono.fromSupplier(() -> this.support.encodeEntity(entityToEncode));
    }

    @Override
    public <T> Mono<T> decodeEntity(Object id, String source, Long cas, Instant expiryTime, Class<T> entityClass, String scope, String collection, Object txResultHolder, CouchbaseResourceHolder holder) {
        return Mono.fromSupplier(() -> this.support.decodeEntity(id, source, cas, expiryTime, entityClass, scope, collection, txResultHolder, holder));
    }

    @Override
    public <T> Mono<T> applyResult(T entity, CouchbaseDocument converted, Object id, Long cas, Object txResultHolder, CouchbaseResourceHolder holder) {
        return Mono.fromSupplier(() -> this.support.applyResult(entity, converted, id, cas, txResultHolder, holder));
    }

    @Override
    public Long getCas(Object entity) {
        return this.support.getCas(entity);
    }

    @Override
    public Object getId(Object entity) {
        return this.support.getId(entity);
    }

    @Override
    public String getJavaNameForEntity(Class<?> clazz) {
        return this.support.getJavaNameForEntity(clazz);
    }

    @Override
    public TranslationService getTranslationService() {
        return this.support.getTranslationService();
    }
}

