/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.kv.SamplingScan;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.ScanTerm;
import com.couchbase.client.java.kv.ScanType;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRangeScanOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import reactor.core.publisher.Flux;

public class ReactiveRangeScanOperationSupport
implements ReactiveRangeScanOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveRangeScanOperationSupport.class);

    ReactiveRangeScanOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveRangeScanOperation.ReactiveRangeScan<T> rangeScan(Class<T> domainType) {
        return new ReactiveRangeScanSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, null, null, null, null, this.template.support());
    }

    static class ReactiveRangeScanSupport<T>
    implements ReactiveRangeScanOperation.ReactiveRangeScan<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final ScanOptions options;
        private final Object sort;
        private final MutationState mutationState;
        private final Integer batchItemLimit;
        private final Integer batchByteLimit;
        private final ReactiveTemplateSupport support;

        ReactiveRangeScanSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, ScanOptions options, Object sort, MutationState mutationState, Integer batchItemLimit, Integer batchByteLimit, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.sort = sort;
            this.mutationState = mutationState;
            this.batchItemLimit = batchItemLimit;
            this.batchByteLimit = batchByteLimit;
            this.support = support;
        }

        @Override
        public ReactiveRangeScanOperation.TerminatingRangeScan<T> withOptions(ScanOptions options) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, options != null ? options : this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public ReactiveRangeScanOperation.RangeScanWithOptions<T> inCollection(String collection) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public ReactiveRangeScanOperation.RangeScanInCollection<T> inScope(String scope) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public ReactiveRangeScanOperation.RangeScanInScope<T> withSort(Object sort) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, sort, this.mutationState, this.batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public ReactiveRangeScanOperation.RangeScanWithSort<T> consistentWith(MutationState mutationState) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.sort, mutationState, this.batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public <R> ReactiveRangeScanOperation.RangeScanConsistentWith<R> as(Class<R> returnType) {
            return new ReactiveRangeScanSupport<R>(this.template, returnType, this.scope, this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public ReactiveRangeScanOperation.RangeScanWithProjection<T> withBatchItemLimit(Integer batchItemLimit) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.sort, this.mutationState, batchItemLimit, this.batchByteLimit, this.support);
        }

        @Override
        public ReactiveRangeScanOperation.RangeScanWithBatchItemLimit<T> withBatchByteLimit(Integer batchByteLimit) {
            return new ReactiveRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, batchByteLimit, this.support);
        }

        @Override
        public Flux<T> rangeScan(String lower, String upper) {
            return this.rangeScan(lower, upper, false, null, null);
        }

        @Override
        public Flux<T> sampleScan(Long limit, Long ... seed) {
            return this.rangeScan(null, null, true, limit, seed != null && seed.length > 0 ? seed[0] : null);
        }

        Flux<T> rangeScan(String lower, String upper, boolean isSamplingScan, Long limit, Long seed) {
            PseudoArgs<ScanOptions> pArgs = new PseudoArgs<ScanOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("rangeScan lower={} upper={} {}", new Object[]{lower, upper, pArgs});
            }
            ReactiveCollection rc = this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive();
            SamplingScan scanType = null;
            if (isSamplingScan) {
                scanType = ScanType.samplingScan((long)limit, (long)(seed != null ? seed : 0L));
            } else {
                ScanTerm lowerTerm = null;
                ScanTerm upperTerm = null;
                if (lower != null) {
                    lowerTerm = ScanTerm.inclusive((String)lower);
                }
                if (upper != null) {
                    upperTerm = ScanTerm.inclusive((String)upper);
                }
                scanType = ScanType.rangeScan((ScanTerm)lowerTerm, (ScanTerm)upperTerm);
            }
            Flux reactiveEntities = TransactionalSupport.verifyNotInTransaction("rangeScan").thenMany((Publisher)rc.scan((ScanType)scanType, this.buildScanOptions(pArgs.getOptions(), false)).flatMap(result -> this.support.decodeEntity(result.id(), new String(result.contentAsBytes(), StandardCharsets.UTF_8), result.cas(), result.expiryTime().orElse(null), this.domainType, pArgs.getScope(), pArgs.getCollection(), null, null)));
            return reactiveEntities.onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<String> rangeScanIds(String upper, String lower) {
            return this.rangeScanIds(upper, lower, false, null, null);
        }

        @Override
        public Flux<String> sampleScanIds(Long limit, Long ... seed) {
            return this.rangeScanIds(null, null, true, limit, seed != null && seed.length > 0 ? seed[0] : null);
        }

        Flux<String> rangeScanIds(String lower, String upper, boolean isSamplingScan, Long limit, Long seed) {
            PseudoArgs<ScanOptions> pArgs = new PseudoArgs<ScanOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("rangeScan lower={} upper={} {}", new Object[]{lower, upper, pArgs});
            }
            ReactiveCollection rc = this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive();
            SamplingScan scanType = null;
            if (isSamplingScan) {
                scanType = ScanType.samplingScan((long)limit, (long)(seed != null ? seed : 0L));
            } else {
                ScanTerm lowerTerm = null;
                ScanTerm upperTerm = null;
                if (lower != null) {
                    lowerTerm = ScanTerm.inclusive((String)lower);
                }
                if (upper != null) {
                    upperTerm = ScanTerm.inclusive((String)upper);
                }
                scanType = ScanType.rangeScan((ScanTerm)lowerTerm, (ScanTerm)upperTerm);
            }
            Flux reactiveEntities = TransactionalSupport.verifyNotInTransaction("rangeScanIds").thenMany((Publisher)rc.scan((ScanType)scanType, this.buildScanOptions(pArgs.getOptions(), true)).map(result -> result.id()));
            return reactiveEntities.onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        private ScanOptions buildScanOptions(ScanOptions options, Boolean idsOnly) {
            return OptionsBuilder.buildScanOptions(options, this.sort, idsOnly, this.mutationState, this.batchByteLimit, this.batchItemLimit);
        }
    }
}

