/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.util.Collection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.couchbase.core.convert.CouchbaseConversionContext;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiators;

public abstract class AbstractCouchbaseConverter
implements CouchbaseConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected EntityInstantiators instantiators = new EntityInstantiators();
    protected CustomConversions conversions;

    protected AbstractCouchbaseConverter(GenericConversionService conversionService, CustomConversions customConversions) {
        this.conversionService = conversionService;
        this.conversions = customConversions;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    public void setInstantiators(EntityInstantiators instantiators) {
        this.instantiators = instantiators;
    }

    public void afterPropertiesSet() {
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public Object convertForWriteIfNeeded(CouchbasePersistentProperty prop, ConvertingPropertyAccessor<Object> accessor, boolean processValueConverter) {
        boolean canConvert;
        Object value = accessor.getProperty((PersistentProperty)prop, prop.getType());
        if (value == null) {
            return null;
        }
        if (processValueConverter && this.conversions.hasValueConverter((PersistentProperty)prop)) {
            return this.conversions.getPropertyValueConversions().getValueConverter((PersistentProperty)prop).write(value, (ValueConversionContext)new CouchbaseConversionContext(prop, (MappingCouchbaseConverter)this, accessor));
        }
        Class targetClass = this.conversions.getCustomWriteTarget(value.getClass()).orElse(null);
        boolean bl = canConvert = targetClass == null ? false : this.conversionService.canConvert(new TypeDescriptor(prop.getField()), TypeDescriptor.valueOf((Class)targetClass));
        if (canConvert) {
            return this.conversionService.convert(value, new TypeDescriptor(prop.getField()), TypeDescriptor.valueOf((Class)targetClass));
        }
        Object result = this.conversions.getCustomWriteTarget(prop.getType()).map(it -> this.conversionService.convert(value, new TypeDescriptor(prop.getField()), TypeDescriptor.valueOf((Class)it))).orElse(value);
        return result;
    }

    @Override
    public Object convertForWriteIfNeeded(Object inValue) {
        if (inValue == null) {
            return null;
        }
        Object value = this.conversions.getCustomWriteTarget(inValue.getClass()).map(it -> this.conversionService.convert(inValue, it)).orElse(inValue);
        Class<?> elementType = value.getClass();
        if (elementType != null && !this.conversions.isSimpleType(elementType)) {
            if (value instanceof Collection || elementType.isArray()) {
                TypeInformation type = TypeInformation.of(value.getClass());
                value = ((MappingCouchbaseConverter)this).writeCollectionInternal(MappingCouchbaseConverter.asCollection(value), new CouchbaseList(this.conversions.getSimpleTypeHolder()), type, null, null);
            } else {
                CouchbaseDocument embeddedDoc = new CouchbaseDocument();
                TypeInformation type = TypeInformation.of(value.getClass());
                ((MappingCouchbaseConverter)this).writeInternalRoot(value, embeddedDoc, type, false, null, true);
                value = embeddedDoc;
            }
        }
        return value;
    }

    @Override
    public Class<?> getWriteClassFor(Class<?> clazz) {
        return this.conversions.getCustomWriteTarget(clazz).orElse(clazz);
    }

    @Override
    public CustomConversions getConversions() {
        return this.conversions;
    }
}

