/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.index;

import org.springframework.data.core.TypeInformation;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.index.CouchbasePersistentEntityIndexResolver;
import org.springframework.data.couchbase.core.index.IndexDefinition;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public interface QueryIndexResolver {
    public static QueryIndexResolver create(MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext, CouchbaseOperations operations) {
        Assert.notNull(mappingContext, (String)"CouchbaseMappingContext must not be null!");
        return new CouchbasePersistentEntityIndexResolver(mappingContext, operations);
    }

    public Iterable<? extends IndexDefinition> resolveIndexFor(TypeInformation<?> var1);

    default public Iterable<? extends IndexDefinition> resolveIndexFor(Class<?> entityType) {
        return this.resolveIndexFor(TypeInformation.of(entityType));
    }
}

