/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.couchbase.core.index.CouchbasePersistentEntityIndexCreator;
import org.springframework.data.couchbase.core.mapping.BasicCouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.BasicCouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class CouchbaseMappingContext
extends AbstractMappingContext<BasicCouchbasePersistentEntity<?>, CouchbasePersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private ApplicationContext context;
    private FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private boolean autoIndexCreation = true;
    private ApplicationEventPublisher eventPublisher;
    private CouchbasePersistentEntityIndexCreator indexCreator = null;

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy == null ? DEFAULT_NAMING_STRATEGY : fieldNamingStrategy;
    }

    protected <T> BasicCouchbasePersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicCouchbasePersistentEntity<T> entity = new BasicCouchbasePersistentEntity<T>(typeInformation);
        if (this.context != null) {
            entity.setEnvironment(this.context.getEnvironment());
        }
        return entity;
    }

    protected CouchbasePersistentProperty createPersistentProperty(Property property, BasicCouchbasePersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new BasicCouchbasePersistentProperty(property, owner, simpleTypeHolder, this.fieldNamingStrategy);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        super.setApplicationContext(applicationContext);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
        if (this.eventPublisher == null) {
            this.eventPublisher = this.context;
        }
    }

    public boolean isAutoIndexCreation() {
        return this.autoIndexCreation;
    }

    public void setAutoIndexCreation(boolean autoCreateIndexes) {
        this.autoIndexCreation = autoCreateIndexes;
    }

    protected Optional<BasicCouchbasePersistentEntity<?>> addPersistentEntity(TypeInformation<?> typeInformation) {
        Optional entity = super.addPersistentEntity(typeInformation);
        if (this.eventPublisher != null && entity.isPresent() && this.indexCreator != null && !this.indexCreator.hasSeen((CouchbasePersistentEntity)entity.get())) {
            this.eventPublisher.publishEvent((ApplicationEvent)new MappingContextEvent((MappingContext)this, (PersistentEntity)entity.get()));
        }
        return entity;
    }

    public BasicCouchbasePersistentEntity<?> getPersistentEntity(TypeInformation<?> typeInformation) {
        Optional<BasicCouchbasePersistentEntity<?>> entity = this.addPersistentEntity(typeInformation);
        return entity.isPresent() ? entity.get() : null;
    }

    public void setIndexCreator(CouchbasePersistentEntityIndexCreator indexCreator) {
        this.indexCreator = indexCreator;
    }
}

