/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.support;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetOptions;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.query.OptionsBuilder;

public class PseudoArgs<OPTS> {
    private OPTS options;
    private final String scopeName;
    private final String collectionName;

    public PseudoArgs(String scopeName, String collectionName, OPTS options) {
        this.options = options;
        this.scopeName = scopeName;
        this.collectionName = collectionName;
    }

    public PseudoArgs(ReactiveCouchbaseTemplate template, String scope, String collection, OPTS options, Class<?> domainType) {
        GetOptions gOptions;
        String scopeForQuery = null;
        String collectionForQuery = null;
        Object optionsForQuery = null;
        PseudoArgs<?> threadLocal = template.getPseudoArgs();
        template.setPseudoArgs(null);
        if (threadLocal != null) {
            scopeForQuery = threadLocal.getScope();
            collectionForQuery = threadLocal.getCollection();
            optionsForQuery = threadLocal.getOptions();
        }
        scopeForQuery = OptionsBuilder.fromFirst(null, scopeForQuery, scope);
        collectionForQuery = OptionsBuilder.fromFirst(null, collectionForQuery, collection);
        optionsForQuery = OptionsBuilder.fromFirst(null, options, optionsForQuery);
        if (collectionForQuery != null && scopeForQuery == null) {
            scopeForQuery = template.getScopeName();
        }
        if ((scopeForQuery == null || "_default".equals(scopeForQuery)) && (collectionForQuery == null || "_default".equals(collectionForQuery))) {
            collectionForQuery = null;
            scopeForQuery = null;
        }
        this.scopeName = scopeForQuery;
        this.collectionName = collectionForQuery;
        if (scopeForQuery != null && collectionForQuery == null) {
            throw new CouchbaseException((Throwable)new IllegalArgumentException("if scope is not default or null, then collection must be specified"));
        }
        if (optionsForQuery instanceof GetAndLockOptions) {
            GetAndLockOptions gOptions2 = optionsForQuery;
            if (gOptions2.build().transcoder() == null) {
                gOptions2.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
            }
        } else if (optionsForQuery instanceof GetAndTouchOptions) {
            GetAndTouchOptions gOptions3 = optionsForQuery;
            if (gOptions3.build().transcoder() == null) {
                gOptions3.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
            }
        } else if (optionsForQuery instanceof GetOptions && (gOptions = (GetOptions)optionsForQuery).build().transcoder() == null) {
            gOptions.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
        }
        this.options = optionsForQuery;
    }

    public OPTS getOptions() {
        return this.options;
    }

    public String getScope() {
        return this.scopeName;
    }

    public String getCollection() {
        return this.collectionName;
    }

    public String toString() {
        return "scope: " + this.getScope() + " collection: " + this.getCollection() + " options: " + String.valueOf(this.getOptions());
    }
}

