/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.lang.reflect.Method;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.core.ReactiveWrappers;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.ClassUtils;

public class ReactiveCouchbaseQueryMethod
extends CouchbaseQueryMethod {
    private static final TypeInformation<Page> PAGE_TYPE = TypeInformation.of(Page.class);
    private static final TypeInformation<Slice> SLICE_TYPE = TypeInformation.of(Slice.class);
    private final Lazy<Boolean> isCollectionQueryCouchbase;

    public ReactiveCouchbaseQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext) {
        super(method, metadata, projectionFactory, mappingContext);
        if (ReflectionUtils.hasParameterOfType((Method)method, Pageable.class)) {
            boolean singleWrapperWithWrappedPageableResult;
            TypeInformation returnType = TypeInformation.fromReturnTypeOf((Method)method);
            boolean multiWrapper = ReactiveWrappers.isMultiValueType((Class)returnType.getType());
            boolean bl = singleWrapperWithWrappedPageableResult = ReactiveWrappers.isSingleValueType((Class)returnType.getType()) && (PAGE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()) || SLICE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()));
            if (singleWrapperWithWrappedPageableResult) {
                throw new InvalidDataAccessApiUsageException(String.format("'%s.%s' must not use sliced or paged execution. Please use Flux.buffer(size, skip).", ClassUtils.getShortName(method.getDeclaringClass()), method.getName()));
            }
            if (!multiWrapper) {
                throw new IllegalStateException(String.format("Method has to use a either multi-item reactive wrapper return type or a wrapped Page/Slice type. Offending method: %s", method.toString()));
            }
            if (ReflectionUtils.hasParameterOfType((Method)method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameter. Use sorting capabilities on Pageable instead! Offending method: %s", method.toString()));
            }
        }
        this.isCollectionQueryCouchbase = Lazy.of(() -> {
            boolean result = !this.isPageQuery() && !this.isSliceQuery() && ReactiveWrappers.isMultiValueType((Class)metadata.getReturnType(method).getType());
            return result;
        });
    }

    public boolean isStreamQuery() {
        return true;
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQueryCouchbase.get();
    }
}

