/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.N1QLQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ReturnedType;

public class N1qlUtils {
    public static final Converter<? super CouchbasePersistentProperty, String> FIELD_NAME_ESCAPED = new Converter<CouchbasePersistentProperty, String>(){

        public String convert(CouchbasePersistentProperty source) {
            return "`" + source.getFieldName() + "`";
        }
    };

    public static N1QLExpression escapedBucket(String bucketName) {
        return N1QLExpression.i(bucketName);
    }

    public static N1QLExpression createSelectClauseForEntity(String bucketName, ReturnedType returnedType, CouchbaseConverter converter) {
        N1QLExpression bucket = N1qlUtils.escapedBucket(bucketName);
        N1QLExpression metaId = N1QLExpression.path(N1QLExpression.meta(bucket), "id").as(N1QLExpression.x("__id"));
        N1QLExpression metaCas = N1QLExpression.path(N1QLExpression.meta(bucket), "cas").as(N1QLExpression.x("__cas"));
        ArrayList<N1QLExpression> expList = new ArrayList<N1QLExpression>();
        expList.add(metaId);
        expList.add(metaCas);
        if (returnedType != null && returnedType.needsCustomConstruction()) {
            List properties = returnedType.getInputProperties();
            CouchbasePersistentEntity entity = (CouchbasePersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(returnedType.getDomainType());
            for (String property : properties) {
                expList.add(N1QLExpression.path(bucket, N1QLExpression.i(((CouchbasePersistentProperty)entity.getRequiredPersistentProperty(property)).getFieldName())));
            }
        } else {
            expList.add(N1QLExpression.path(bucket, "*"));
        }
        N1QLExpression[] propertiesExp = new N1QLExpression[expList.size()];
        propertiesExp = expList.toArray(propertiesExp);
        return N1QLExpression.select(propertiesExp);
    }

    public static N1QLExpression createReturningExpressionForDelete(String bucketName) {
        N1QLExpression fullEntity = N1QLExpression.path(N1QLExpression.i(bucketName), "*");
        N1QLExpression metaId = N1QLExpression.path(N1QLExpression.meta(N1QLExpression.i(bucketName)), "id").as(N1QLExpression.x("__id"));
        N1QLExpression metaCas = N1QLExpression.path(N1QLExpression.meta(N1QLExpression.i(bucketName)), "cas").as(N1QLExpression.x("__cas"));
        ArrayList<N1QLExpression> expList = new ArrayList<N1QLExpression>();
        expList.add(fullEntity);
        expList.add(metaId);
        expList.add(metaCas);
        StringBuilder sb = new StringBuilder();
        for (N1QLExpression exp : expList) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(exp.toString());
        }
        return N1QLExpression.x(sb.toString());
    }

    public static N1QLExpression createSelectClauseForEntity(String bucketName) {
        return N1qlUtils.createSelectClauseForEntity(bucketName, null, null);
    }

    public static N1QLExpression createSelectFromForEntity(String bucketName) {
        return N1qlUtils.createSelectClauseForEntity(bucketName).from(bucketName);
    }

    public static N1QLExpression createWhereFilterForEntity(N1QLExpression baseWhereCriteria, CouchbaseConverter converter, EntityMetadata<?> entityInformation) {
        N1QLExpression typeSelector;
        String typeKey = converter.getTypeKey();
        String typeValue = entityInformation.getJavaType().getName();
        Alias alias = converter.getTypeAlias(TypeInformation.of((Class)entityInformation.getJavaType()));
        if (alias != null && alias.isPresent()) {
            typeValue = alias.toString();
        }
        N1QLExpression n1QLExpression = typeSelector = !N1qlUtils.empty(typeKey) && !N1qlUtils.empty(typeValue) ? N1QLExpression.i(typeKey).eq(N1QLExpression.s(typeValue)) : null;
        if (baseWhereCriteria == null) {
            baseWhereCriteria = typeSelector;
        } else if (typeSelector != null) {
            baseWhereCriteria = N1QLExpression.x("(" + baseWhereCriteria.toString() + ")").and(typeSelector);
        }
        return baseWhereCriteria;
    }

    private static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public static PersistentPropertyPath<CouchbasePersistentProperty> getPathWithAlternativeFieldNames(CouchbaseConverter converter, PropertyPath property) {
        PersistentPropertyPath path = converter.getMappingContext().getPersistentPropertyPath(property);
        return path;
    }

    public static String getDottedPathWithAlternativeFieldNames(PersistentPropertyPath<CouchbasePersistentProperty> path) {
        return path.toDotPath(FIELD_NAME_ESCAPED);
    }

    public static N1QLExpression[] createSort(Sort sort) {
        ArrayList<N1QLExpression> cbSortList = new ArrayList<N1QLExpression>();
        for (Sort.Order order : sort) {
            String orderProperty = order.getProperty();
            String[] orderPropertyParts = orderProperty.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (String part : orderPropertyParts) {
                if (sb.length() != 0) {
                    sb.append(".");
                }
                sb.append(N1QLExpression.i(part).toString());
            }
            N1QLExpression orderFieldName = N1QLExpression.x(sb.toString());
            if (order.isIgnoreCase()) {
                orderFieldName = orderFieldName.convertToString().lower();
            }
            if (order.isAscending()) {
                cbSortList.add(orderFieldName.asc());
                continue;
            }
            cbSortList.add(orderFieldName.desc());
        }
        return cbSortList.toArray(new N1QLExpression[cbSortList.size()]);
    }

    public static <T> N1QLExpression createCountQueryForEntity(String bucketName, CouchbaseConverter converter, CouchbaseEntityInformation<T, String> entityInformation) {
        N1QLExpression entityFilter = N1qlUtils.createWhereFilterForEntity(null, converter, entityInformation);
        N1QLExpression expression = N1QLExpression.select(N1QLExpression.count(N1QLExpression.x("*")).as(N1QLExpression.x("count")).from(N1qlUtils.escapedBucket(bucketName)));
        if (entityFilter == null) {
            return expression;
        }
        return expression.where(entityFilter);
    }

    public static N1QLQuery buildQuery(N1QLExpression expression, JsonValue queryPlaceholderValues, QueryScanConsistency scanConsistency) {
        QueryOptions opts = QueryOptions.queryOptions().scanConsistency(scanConsistency);
        if (queryPlaceholderValues instanceof JsonObject && !((JsonObject)queryPlaceholderValues).isEmpty()) {
            opts.parameters((JsonObject)queryPlaceholderValues);
        } else if (queryPlaceholderValues instanceof JsonArray && !((JsonArray)queryPlaceholderValues).isEmpty()) {
            opts.parameters((JsonArray)queryPlaceholderValues);
        }
        return new N1QLQuery(expression, opts);
    }
}

