/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.lang.reflect.AnnotatedElement;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.repository.Collection;
import org.springframework.data.couchbase.repository.ScanConsistency;
import org.springframework.data.couchbase.repository.Scope;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadata;

public abstract class CouchbaseRepositoryBase<T, ID> {
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private final Class<?> repositoryInterface;
    private CrudMethodMetadata crudMethodMetadata;

    public CouchbaseRepositoryBase(CouchbaseEntityInformation<T, String> entityInformation, Class<?> repositoryInterface) {
        this.entityInformation = entityInformation;
        this.repositoryInterface = repositoryInterface;
    }

    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }

    public CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    Class<T> getJavaType() {
        return this.getEntityInformation().getJavaType();
    }

    <S extends T> String getId(S entity) {
        return String.valueOf(this.getEntityInformation().getId(entity));
    }

    protected String getScope() {
        String fromAnnotation = OptionsBuilder.annotationString(Scope.class, "_default", new AnnotatedElement[]{this.getJavaType(), this.getRepositoryInterface()});
        String fromMetadata = this.crudMethodMetadata != null ? this.crudMethodMetadata.getScope() : null;
        PseudoArgs<?> pa = this.getReactiveTemplate().getPseudoArgs();
        String fromThreadLocal = pa != null ? pa.getScope() : null;
        return OptionsBuilder.fromFirst("_default", fromThreadLocal, fromMetadata, fromAnnotation);
    }

    protected String getCollection() {
        String fromAnnotation = OptionsBuilder.annotationString(Collection.class, "_default", new AnnotatedElement[]{this.getJavaType(), this.getRepositoryInterface()});
        String fromMetadata = this.crudMethodMetadata != null ? this.crudMethodMetadata.getCollection() : null;
        PseudoArgs<?> pa = this.getReactiveTemplate().getPseudoArgs();
        String fromThreadLocal = pa != null ? pa.getCollection() : null;
        return OptionsBuilder.fromFirst("_default", fromThreadLocal, fromMetadata, fromAnnotation);
    }

    protected CommonOptions<?> getOptions() {
        PseudoArgs<?> pa = this.getReactiveTemplate().getPseudoArgs();
        return pa != null ? (CommonOptions)pa.getOptions() : null;
    }

    protected abstract ReactiveCouchbaseTemplate getReactiveTemplate();

    QueryScanConsistency getQueryScanConsistency() {
        ScanConsistency sc = this.crudMethodMetadata.getScanConsistency();
        QueryScanConsistency fromMeta = sc != null ? sc.query() : null;
        QueryScanConsistency fromAnnotation = OptionsBuilder.annotationAttribute(ScanConsistency.class, "query", QueryScanConsistency.NOT_BOUNDED, new AnnotatedElement[]{this.getJavaType(), this.repositoryInterface});
        return OptionsBuilder.fromFirst(QueryScanConsistency.NOT_BOUNDED, fromMeta, fromAnnotation);
    }

    void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.crudMethodMetadata = crudMethodMetadata;
    }
}

