/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.SimpleElasticsearchRepository;
import org.springframework.util.Assert;

public abstract class AbstractElasticsearchRepository<T, ID>
implements ElasticsearchRepository<T, ID> {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractElasticsearchRepository.class);
    protected ElasticsearchOperations elasticsearchOperations;
    protected Class<T> entityClass;
    protected ElasticsearchEntityInformation<T, ID> entityInformation;

    public AbstractElasticsearchRepository() {
    }

    public AbstractElasticsearchRepository(ElasticsearchOperations elasticsearchOperations) {
        Assert.notNull((Object)elasticsearchOperations, (String)"ElasticsearchOperations must not be null!");
        this.setElasticsearchOperations(elasticsearchOperations);
    }

    public AbstractElasticsearchRepository(ElasticsearchEntityInformation<T, ID> metadata, ElasticsearchOperations elasticsearchOperations) {
        this(elasticsearchOperations);
        Assert.notNull(metadata, (String)"ElasticsearchEntityInformation must not be null!");
        this.entityInformation = metadata;
        this.setEntityClass(this.entityInformation.getJavaType());
        try {
            if (super.createIndexAndMapping()) {
            }
        }
        catch (ElasticsearchException exception) {
            LOGGER.error("failed to load elasticsearch nodes : {}", (Object)exception.getDetailedMessage());
        }
    }

    private void createIndex() {
        this.elasticsearchOperations.createIndex(this.getEntityClass());
    }

    private void putMapping() {
        this.elasticsearchOperations.putMapping(this.getEntityClass());
    }

    private boolean createIndexAndMapping() {
        return this.elasticsearchOperations.getPersistentEntityFor(this.getEntityClass()).isCreateIndexAndMapping();
    }

    public Optional<T> findById(ID id) {
        GetQuery query = new GetQuery();
        query.setId(this.stringIdRepresentation(id));
        return Optional.ofNullable(this.elasticsearchOperations.queryForObject(query, this.getEntityClass()));
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
    }

    public Page<T> findAll(Pageable pageable) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable(pageable).build();
        return this.elasticsearchOperations.queryForPage(query, this.getEntityClass());
    }

    public Iterable<T> findAll(Sort sort) {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable((Pageable)PageRequest.of((int)0, (int)itemCount, (Sort)sort)).build();
        return this.elasticsearchOperations.queryForPage(query, this.getEntityClass());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        List<String> stringIds = this.stringIdsRepresentation(ids);
        if (stringIds.isEmpty()) {
            return Collections.emptyList();
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withIds(stringIds).build();
        return this.elasticsearchOperations.multiGet(query, this.getEntityClass());
    }

    public long count() {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        return this.elasticsearchOperations.count(query, this.getEntityClass());
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        this.elasticsearchOperations.index(this.createIndexQuery(entity));
        this.elasticsearchOperations.refresh(this.entityInformation.getIndexName());
        return entity;
    }

    public <S extends T> List<S> save(List<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        Assert.notEmpty(entities, (String)"Cannot insert empty List.");
        ArrayList<IndexQuery> queries = new ArrayList<IndexQuery>();
        for (S s : entities) {
            queries.add(this.createIndexQuery(s));
        }
        this.elasticsearchOperations.bulkIndex(queries);
        this.elasticsearchOperations.refresh(this.entityInformation.getIndexName());
        return entities;
    }

    @Override
    public <S extends T> S index(S entity) {
        return this.save(entity);
    }

    @Override
    public <S extends T> S indexWithoutRefresh(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        this.elasticsearchOperations.index(this.createIndexQuery(entity));
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        ArrayList<IndexQuery> queries = new ArrayList<IndexQuery>();
        for (S s : entities) {
            queries.add(this.createIndexQuery(s));
        }
        this.elasticsearchOperations.bulkIndex(queries);
        this.elasticsearchOperations.refresh(this.entityInformation.getIndexName());
        return entities;
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    @Override
    public Iterable<T> search(QueryBuilder query) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(query).build();
        int count = (int)this.elasticsearchOperations.count(searchQuery, this.getEntityClass());
        if (count == 0) {
            return new PageImpl(Collections.emptyList());
        }
        searchQuery.setPageable((Pageable)PageRequest.of((int)0, (int)count));
        return this.elasticsearchOperations.queryForPage(searchQuery, this.getEntityClass());
    }

    @Override
    public Page<T> search(QueryBuilder query, Pageable pageable) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(query).withPageable(pageable).build();
        return this.elasticsearchOperations.queryForPage(searchQuery, this.getEntityClass());
    }

    @Override
    public Page<T> search(SearchQuery query) {
        return this.elasticsearchOperations.queryForPage(query, this.getEntityClass());
    }

    @Override
    public Page<T> searchSimilar(T entity, String[] fields, Pageable pageable) {
        Assert.notNull(entity, (String)"Cannot search similar records for 'null'.");
        Assert.notNull((Object)pageable, (String)"'pageable' cannot be 'null'");
        MoreLikeThisQuery query = new MoreLikeThisQuery();
        query.setId(this.stringIdRepresentation(this.extractIdFromBean(entity)));
        query.setPageable(pageable);
        if (fields != null) {
            query.addFields(fields);
        }
        return this.elasticsearchOperations.moreLikeThis(query, this.getEntityClass());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.elasticsearchOperations.delete(this.entityInformation.getIndexName(), this.entityInformation.getType(), this.stringIdRepresentation(id));
        this.elasticsearchOperations.refresh(this.entityInformation.getIndexName());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.deleteById(this.extractIdFromBean(entity));
        this.elasticsearchOperations.refresh(this.entityInformation.getIndexName());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        DeleteQuery deleteQuery = new DeleteQuery();
        deleteQuery.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        this.elasticsearchOperations.delete(deleteQuery, this.getEntityClass());
        this.elasticsearchOperations.refresh(this.entityInformation.getIndexName());
    }

    @Override
    public void refresh() {
        this.elasticsearchOperations.refresh(this.getEntityClass());
    }

    private IndexQuery createIndexQuery(T entity) {
        IndexQuery query = new IndexQuery();
        query.setObject(entity);
        query.setId(this.stringIdRepresentation(this.extractIdFromBean(entity)));
        query.setVersion(this.extractVersionFromBean(entity));
        query.setParentId(this.extractParentIdFromBean(entity));
        return query;
    }

    private Class<T> resolveReturnedClassFromGenericType() {
        ParameterizedType parameterizedType = this.resolveReturnedClassFromGenericType(this.getClass());
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private ParameterizedType resolveReturnedClassFromGenericType(Class<?> clazz) {
        ParameterizedType parameterizedType;
        Type rawtype;
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && SimpleElasticsearchRepository.class.equals((Object)(rawtype = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()))) {
            return parameterizedType;
        }
        return this.resolveReturnedClassFromGenericType(clazz.getSuperclass());
    }

    @Override
    public Class<T> getEntityClass() {
        if (!this.isEntityClassSet()) {
            try {
                this.entityClass = this.resolveReturnedClassFromGenericType();
            }
            catch (Exception e) {
                throw new InvalidDataAccessApiUsageException("Unable to resolve EntityClass. Please use according setter!", (Throwable)e);
            }
        }
        return this.entityClass;
    }

    private boolean isEntityClassSet() {
        return this.entityClass != null;
    }

    public final void setEntityClass(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null.");
        this.entityClass = entityClass;
    }

    public final void setElasticsearchOperations(ElasticsearchOperations elasticsearchOperations) {
        Assert.notNull((Object)elasticsearchOperations, (String)"ElasticsearchOperations must not be null.");
        this.elasticsearchOperations = elasticsearchOperations;
    }

    protected ID extractIdFromBean(T entity) {
        return (ID)this.entityInformation.getId(entity);
    }

    private List<String> stringIdsRepresentation(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        ArrayList<String> stringIds = new ArrayList<String>();
        for (ID id : ids) {
            stringIds.add(this.stringIdRepresentation(id));
        }
        return stringIds;
    }

    protected abstract String stringIdRepresentation(ID var1);

    private Long extractVersionFromBean(T entity) {
        return this.entityInformation.getVersion(entity);
    }

    private String extractParentIdFromBean(T entity) {
        return this.entityInformation.getParentId(entity);
    }
}

