/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.net.ConnectException;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ElasticsearchExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        ElasticsearchException elasticsearchException;
        if (ex instanceof ElasticsearchException && !this.indexAvailable(elasticsearchException = (ElasticsearchException)ex)) {
            return new NoSuchIndexException(ObjectUtils.nullSafeToString((Object)elasticsearchException.getMetadata("es.index")), ex);
        }
        if (ex.getCause() instanceof ConnectException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private boolean indexAvailable(ElasticsearchException ex) {
        List metadata = ex.getMetadata("es.index_uuid");
        if (metadata == null && ex instanceof ElasticsearchStatusException) {
            return StringUtils.hasText((String)ObjectUtils.nullSafeToString((Object)((ElasticsearchStatusException)ex).getIndex()));
        }
        return !CollectionUtils.contains(metadata.iterator(), (Object)"_na_");
    }
}

