/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.DefaultIndexOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.support.SearchHitsUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ElasticsearchRestTemplate
extends AbstractElasticsearchTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchRestTemplate.class);
    private final RestHighLevelClient client;
    private final ElasticsearchExceptionTranslator exceptionTranslator;

    public ElasticsearchRestTemplate(RestHighLevelClient client) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.client = client;
        this.exceptionTranslator = new ElasticsearchExceptionTranslator();
        this.initialize(this.createElasticsearchConverter());
    }

    public ElasticsearchRestTemplate(RestHighLevelClient client, ElasticsearchConverter elasticsearchConverter) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.client = client;
        this.exceptionTranslator = new ElasticsearchExceptionTranslator();
        this.initialize(elasticsearchConverter);
    }

    @Override
    public IndexOperations indexOps(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        return new DefaultIndexOperations(this, clazz);
    }

    @Override
    public IndexOperations indexOps(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        return new DefaultIndexOperations(this, index);
    }

    @Override
    public String index(IndexQuery query, IndexCoordinates index) {
        this.maybeCallbackBeforeConvertWithQuery(query, index);
        IndexRequest request = this.requestFactory.indexRequest(query, index);
        IndexResponse indexResponse = this.execute(client -> client.index(request, RequestOptions.DEFAULT));
        Object queryObject = query.getObject();
        if (queryObject != null) {
            this.updateIndexedObject(queryObject, IndexedObjectInformation.of(indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion()));
        }
        this.maybeCallbackAfterSaveWithQuery(query, index);
        return indexResponse.getId();
    }

    @Override
    @Nullable
    public <T> T get(String id, Class<T> clazz, IndexCoordinates index) {
        GetRequest request = this.requestFactory.getRequest(id, index);
        GetResponse response = this.execute(client -> client.get(request, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> callback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        return callback.doWith(DocumentAdapters.from(response));
    }

    @Override
    public <T> List<T> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notEmpty(query.getIds(), (String)"No Id define for Query");
        MultiGetRequest request = this.requestFactory.multiGetRequest(query, clazz, index);
        MultiGetResponse result = this.execute(client -> client.mget(request, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> callback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        return DocumentAdapters.from(result).stream().map(callback::doWith).collect(Collectors.toList());
    }

    @Override
    protected boolean doExists(String id, IndexCoordinates index) {
        GetRequest request = this.requestFactory.getRequest(id, index);
        request.fetchSourceContext(FetchSourceContext.DO_NOT_FETCH_SOURCE);
        return this.execute(client -> client.get(request, RequestOptions.DEFAULT).isExists());
    }

    @Override
    public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of IndexQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        return this.doBulkOperation(queries, bulkOptions, index);
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        this.doBulkOperation(queries, bulkOptions, index);
    }

    @Override
    public String delete(String id, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        DeleteRequest request = this.requestFactory.deleteRequest(this.elasticsearchConverter.convertId(id), routing, index);
        return this.execute(client -> client.delete(request, RequestOptions.DEFAULT).getId());
    }

    @Override
    public void delete(Query query, Class<?> clazz, IndexCoordinates index) {
        DeleteByQueryRequest deleteByQueryRequest = this.requestFactory.deleteByQueryRequest(query, clazz, index);
        this.execute(client -> client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT));
    }

    @Override
    @Deprecated
    public void delete(DeleteQuery deleteQuery, IndexCoordinates index) {
        DeleteByQueryRequest deleteByQueryRequest = this.requestFactory.deleteByQueryRequest(deleteQuery, index);
        this.execute(client -> client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT));
    }

    @Override
    public UpdateResponse update(UpdateQuery query, IndexCoordinates index) {
        UpdateRequest request = this.requestFactory.updateRequest(query, index);
        UpdateResponse.Result result = UpdateResponse.Result.valueOf(this.execute(client -> client.update(request, RequestOptions.DEFAULT)).getResult().name());
        return new UpdateResponse(result);
    }

    private List<IndexedObjectInformation> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        this.maybeCallbackBeforeConvertWithQueries(queries, index);
        BulkRequest bulkRequest = this.requestFactory.bulkRequest(queries, bulkOptions, index);
        List<IndexedObjectInformation> indexedObjectInformationList = this.checkForBulkOperationFailure(this.execute(client -> client.bulk(bulkRequest, RequestOptions.DEFAULT)));
        this.updateIndexedObjectsWithQueries(queries, indexedObjectInformationList);
        this.maybeCallbackAfterSaveWithQueries(queries, index);
        return indexedObjectInformationList;
    }

    @Override
    public long count(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Boolean trackTotalHits = query.getTrackTotalHits();
        query.setTrackTotalHits(true);
        SearchRequest searchRequest = this.requestFactory.searchRequest(query, clazz, index);
        query.setTrackTotalHits(trackTotalHits);
        searchRequest.source().size(0);
        return SearchHitsUtil.getTotalCount(this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT).getHits()));
    }

    @Override
    public <T> SearchHits<T> search(Query query, Class<T> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.requestFactory.searchRequest(query, clazz, index);
        SearchResponse response = this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T>(clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponse.from(response));
    }

    @Override
    public <T> SearchScrollHits<T> searchScrollStart(long scrollTimeInMillis, Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query.getPageable(), (String)"pageable of query must not be null.");
        SearchRequest searchRequest = this.requestFactory.searchRequest(query, clazz, index);
        searchRequest.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        SearchResponse response = this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponse.from(response));
    }

    @Override
    public <T> SearchScrollHits<T> searchScrollContinue(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, IndexCoordinates index) {
        SearchScrollRequest request = new SearchScrollRequest(scrollId);
        request.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        SearchResponse response = this.execute(client -> client.scroll(request, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponse.from(response));
    }

    @Override
    public void searchScrollClear(List<String> scrollIds) {
        try {
            ClearScrollRequest request = new ClearScrollRequest();
            request.scrollIds(scrollIds);
            this.execute(client -> client.clearScroll(request, RequestOptions.DEFAULT));
        }
        catch (Exception e) {
            LOGGER.warn("Could not clear scroll: {}", (Object)e.getMessage());
        }
    }

    @Override
    public SearchResponse suggest(SuggestBuilder suggestion, IndexCoordinates index) {
        SearchRequest searchRequest = this.requestFactory.searchRequest(suggestion, index);
        return this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT));
    }

    @Override
    protected MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest request) {
        MultiSearchResponse response = this.execute(client -> client.multiSearch(request, RequestOptions.DEFAULT));
        MultiSearchResponse.Item[] items = response.getResponses();
        Assert.isTrue((items.length == request.requests().size() ? 1 : 0) != 0, (String)"Response should has same length with queries");
        return items;
    }

    public <T> T execute(ClientCallback<T> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        try {
            return callback.doWithClient(this.client);
        }
        catch (IOException | RuntimeException e) {
            throw this.translateException(e);
        }
    }

    private RuntimeException translateException(Exception exception) {
        RuntimeException runtimeException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception.getMessage(), exception);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }

    @Override
    protected String getClusterVersion() {
        try {
            return this.execute(client -> client.info(RequestOptions.DEFAULT)).getVersion().getNumber();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ClientCallback<T> {
        public T doWithClient(RestHighLevelClient var1) throws IOException;
    }
}

