/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.elasticsearch.core.convert.DateTimeConverters;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchStringQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;

public final class StringQueryUtil {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private static final GenericConversionService conversionService = new GenericConversionService();

    private StringQueryUtil() {
        if (!conversionService.canConvert(Date.class, String.class)) {
            conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (ClassUtils.isPresent((String)"org.joda.time.DateTimeZone", (ClassLoader)ElasticsearchStringQuery.class.getClassLoader())) {
            if (!conversionService.canConvert(ReadableInstant.class, String.class)) {
                conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!conversionService.canConvert(LocalDateTime.class, String.class)) {
                conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
    }

    public static String replacePlaceholders(String input, ParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String placeholder = Pattern.quote(matcher.group()) + "(?!\\d+)";
            int index = (Integer)NumberUtils.parseNumber((String)matcher.group(1), Integer.class);
            result = result.replaceAll(placeholder, Matcher.quoteReplacement(StringQueryUtil.getParameterWithIndex(accessor, index)));
        }
        return result;
    }

    private static String getParameterWithIndex(ParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        String parameterValue = "null";
        if (parameter != null) {
            if (conversionService.canConvert(parameter.getClass(), String.class)) {
                String converted = (String)conversionService.convert(parameter, String.class);
                if (converted != null) {
                    parameterValue = converted;
                }
            } else {
                parameterValue = parameter.toString();
            }
        }
        parameterValue = parameterValue.replaceAll("\"", Matcher.quoteReplacement("\\\""));
        return parameterValue;
    }
}

