/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchClients;
import org.springframework.data.elasticsearch.client.reactive.DefaultWebClientProvider;
import org.springframework.data.elasticsearch.client.reactive.ReactiveRestClients;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.ProxyProvider;

public interface WebClientProvider {
    public static WebClientProvider http() {
        return WebClientProvider.create("http");
    }

    public static WebClientProvider create(String scheme) {
        Assert.hasText((String)scheme, (String)"Protocol scheme must not be empty");
        return new DefaultWebClientProvider(scheme, null);
    }

    public static WebClientProvider create(String scheme, @Nullable ClientHttpConnector connector) {
        Assert.hasText((String)scheme, (String)"Protocol scheme must not be empty");
        return new DefaultWebClientProvider(scheme, connector);
    }

    public WebClient get(InetSocketAddress var1);

    public HttpHeaders getDefaultHeaders();

    public Consumer<Throwable> getErrorListener();

    @Nullable
    public String getPathPrefix();

    public WebClientProvider withDefaultHeaders(HttpHeaders var1);

    public WebClientProvider withErrorListener(Consumer<Throwable> var1);

    public WebClientProvider withPathPrefix(String var1);

    public WebClientProvider withWebClientConfigurer(Function<WebClient, WebClient> var1);

    public WebClientProvider withRequestConfigurer(Consumer<WebClient.RequestHeadersSpec<?>> var1);

    public static WebClientProvider getWebClientProvider(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        Duration connectTimeout = clientConfiguration.getConnectTimeout();
        Duration soTimeout = clientConfiguration.getSocketTimeout();
        HttpClient httpClient = HttpClient.create().compress(true);
        if (!connectTimeout.isNegative()) {
            httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(connectTimeout.toMillis()));
        }
        if (!soTimeout.isNegative()) {
            httpClient = (HttpClient)httpClient.doOnConnected(connection -> connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(soTimeout.toMillis(), TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(soTimeout.toMillis(), TimeUnit.MILLISECONDS)));
        }
        if (clientConfiguration.getProxy().isPresent()) {
            String proxy = clientConfiguration.getProxy().get();
            String[] hostPort = proxy.split(":");
            if (hostPort.length != 2) {
                throw new IllegalArgumentException("invalid proxy configuration " + proxy + ", should be \"host:port\"");
            }
            httpClient = (HttpClient)httpClient.proxy(proxyOptions -> proxyOptions.type(ProxyProvider.Proxy.HTTP).host(hostPort[0]).port(Integer.parseInt(hostPort[1])));
        }
        String scheme = "http";
        if (clientConfiguration.useSsl()) {
            Optional<SSLContext> sslContext = clientConfiguration.getSslContext();
            httpClient = sslContext.isPresent() ? httpClient.secure(sslContextSpec -> sslContextSpec.sslContext((SslContext)new JdkSslContext((SSLContext)sslContext.get(), true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false))) : httpClient.secure();
            scheme = "https";
        }
        WebClientProvider provider = WebClientProvider.create(scheme, (ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        if (clientConfiguration.getPathPrefix() != null) {
            provider = provider.withPathPrefix(clientConfiguration.getPathPrefix());
        }
        Function<WebClient, WebClient> webClientConfigurer = webClient -> {
            for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurer : clientConfiguration.getClientConfigurers()) {
                ClientConfiguration.ClientConfigurationCallback<WebClient> webClientConfigurationCallback;
                if (clientConfigurer instanceof ReactiveRestClients.WebClientConfigurationCallback) {
                    webClientConfigurationCallback = (ReactiveRestClients.WebClientConfigurationCallback)clientConfigurer;
                    webClient = webClientConfigurationCallback.configure((WebClient)webClient);
                }
                if (!(clientConfigurer instanceof ElasticsearchClients.WebClientConfigurationCallback)) continue;
                webClientConfigurationCallback = (ElasticsearchClients.WebClientConfigurationCallback)clientConfigurer;
                webClient = webClientConfigurationCallback.configure((WebClient)webClient);
            }
            return webClient;
        };
        provider = provider.withDefaultHeaders(clientConfiguration.getDefaultHeaders()).withWebClientConfigurer(webClientConfigurer).withRequestConfigurer(requestHeadersSpec -> requestHeadersSpec.headers(httpHeaders -> {
            HttpHeaders suppliedHeaders = clientConfiguration.getHeadersSupplier().get();
            if (suppliedHeaders != null && suppliedHeaders != HttpHeaders.EMPTY) {
                httpHeaders.addAll((MultiValueMap)suppliedHeaders);
            }
        }));
        return provider;
    }
}

