/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.ClosePointInTimeRequest;
import co.elastic.clients.elasticsearch.core.ClosePointInTimeResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeRequest;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeResponse;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.get.GetResult;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Version;
import co.elastic.clients.util.ApiTypeHelper;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.client.UnsupportedBackendOperation;
import org.springframework.data.elasticsearch.client.elc.DocumentAdapters;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.client.elc.EntityAsMap;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.QueryBuilders;
import org.springframework.data.elasticsearch.client.elc.ReactiveClusterTemplate;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveIndicesTemplate;
import org.springframework.data.elasticsearch.client.elc.RequestConverter;
import org.springframework.data.elasticsearch.client.elc.ResponseConverter;
import org.springframework.data.elasticsearch.client.elc.SearchDocumentResponseBuilder;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.client.erhlc.ReactiveClusterOperations;
import org.springframework.data.elasticsearch.client.util.ScrollState;
import org.springframework.data.elasticsearch.core.AbstractReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.AggregationContainer;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ReactiveElasticsearchTemplate
extends AbstractReactiveElasticsearchTemplate {
    private final ReactiveElasticsearchClient client;
    private final RequestConverter requestConverter;
    private final ResponseConverter responseConverter;
    private final JsonpMapper jsonpMapper;
    private final ElasticsearchExceptionTranslator exceptionTranslator;

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client, ElasticsearchConverter converter) {
        super(converter);
        Assert.notNull((Object)client, (String)"client must not be null");
        this.client = client;
        this.jsonpMapper = ((ElasticsearchTransport)client._transport()).jsonpMapper();
        this.requestConverter = new RequestConverter(converter, this.jsonpMapper);
        this.responseConverter = new ResponseConverter(this.jsonpMapper);
        this.exceptionTranslator = new ElasticsearchExceptionTranslator(this.jsonpMapper);
    }

    @Override
    protected <T> Mono<Tuple2<T, AbstractReactiveElasticsearchTemplate.IndexResponseMetaData>> doIndex(T entity, IndexCoordinates index) {
        IndexRequest<?> indexRequest = this.requestConverter.documentIndexRequest(this.getIndexQuery(entity), index, this.getRefreshPolicy());
        return Mono.just(entity).zipWith(Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.index(indexRequest))).map(indexResponse -> new AbstractReactiveElasticsearchTemplate.IndexResponseMetaData(indexResponse.id(), indexResponse.seqNo(), indexResponse.primaryTerm(), indexResponse.version())));
    }

    @Override
    public <T> Flux<T> saveAll(Mono<? extends Collection<? extends T>> entitiesPublisher, IndexCoordinates index) {
        Assert.notNull(entitiesPublisher, (String)"entitiesPublisher must not be null!");
        return entitiesPublisher.flatMapMany(entities -> Flux.fromIterable((Iterable)entities).concatMap(entity -> this.maybeCallBeforeConvert(entity, index))).collectList().map(x$0 -> new AbstractReactiveElasticsearchTemplate.Entities(x$0)).flatMapMany(entities -> {
            if (entities.isEmpty()) {
                return Flux.empty();
            }
            return this.doBulkOperation(entities.indexQueries(), BulkOptions.defaultOptions(), index).index().flatMap(indexAndResponse -> {
                Object savedEntity = entities.entityAt((Long)indexAndResponse.getT1());
                BulkResponseItem response = (BulkResponseItem)indexAndResponse.getT2();
                this.updateIndexedObject(savedEntity, IndexedObjectInformation.of(response.id(), response.seqNo(), response.primaryTerm(), response.version()));
                return this.maybeCallAfterSave(savedEntity, index);
            });
        });
    }

    @Override
    public <T> Mono<T> get(String id, Class<T> entityType, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        GetRequest getRequest = this.requestConverter.documentGetRequest(id, this.routingResolver.getRouting(), index, false);
        Mono getResponse = Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.get(getRequest, EntityAsMap.class)));
        AbstractReactiveElasticsearchTemplate.ReadDocumentCallback callback = new AbstractReactiveElasticsearchTemplate.ReadDocumentCallback(this.converter, entityType, index);
        return getResponse.flatMap(response -> callback.toEntity(DocumentAdapters.from((GetResult<EntityAsMap>)response)));
    }

    @Override
    public Mono<ReindexResponse> reindex(ReindexRequest reindexRequest) {
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        co.elastic.clients.elasticsearch.core.ReindexRequest reindexRequestES = this.requestConverter.reindex(reindexRequest, true);
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.reindex(reindexRequestES))).map(this.responseConverter::reindexResponse);
    }

    @Override
    public Mono<String> submitReindex(ReindexRequest reindexRequest) {
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        co.elastic.clients.elasticsearch.core.ReindexRequest reindexRequestES = this.requestConverter.reindex(reindexRequest, false);
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.reindex(reindexRequestES))).flatMap(response -> response.task() == null ? Mono.error((Throwable)new UnsupportedBackendOperation("ElasticsearchClient did not return a task id on submit request")) : Mono.just((Object)response.task()));
    }

    @Override
    public Mono<Void> bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        Assert.notNull((Object)index, (String)"Index must not be null");
        return this.doBulkOperation(queries, bulkOptions, index).then();
    }

    private Flux<BulkResponseItem> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = this.requestConverter.documentBulkRequest(queries, bulkOptions, index, this.getRefreshPolicy());
        return this.client.bulk(bulkRequest).onErrorMap(e -> new UncategorizedElasticsearchException("Error executing bulk request", (Throwable)e)).flatMap(this::checkForBulkOperationFailure).flatMapMany(response -> Flux.fromIterable((Iterable)response.items()));
    }

    private Mono<BulkResponse> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.errors()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkResponseItem item : bulkResponse.items()) {
                if (item.error() == null) continue;
                failedDocuments.put(item.id(), item.error().reason());
            }
            BulkFailureException exception = new BulkFailureException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
            return Mono.error((Throwable)((Object)exception));
        }
        return Mono.just((Object)bulkResponse);
    }

    @Override
    protected Mono<String> doDeleteById(String id, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return Mono.defer(() -> {
            DeleteRequest deleteRequest = this.requestConverter.documentDeleteRequest(id, routing, index, this.getRefreshPolicy());
            return this.doDelete(deleteRequest);
        });
    }

    private Mono<String> doDelete(DeleteRequest request) {
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.delete(request))).flatMap(deleteResponse -> {
            if (deleteResponse.result() == Result.NotFound) {
                return Mono.empty();
            }
            return Mono.just((Object)deleteResponse.id());
        }).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    @Override
    public <T> Flux<MultiGetItem<T>> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        MgetRequest request = this.requestConverter.documentMgetRequest(query, clazz, index);
        AbstractReactiveElasticsearchTemplate.ReadDocumentCallback callback = new AbstractReactiveElasticsearchTemplate.ReadDocumentCallback(this.converter, clazz, index);
        Publisher<T> response = this.execute((ReactiveElasticsearchClient client) -> client.mget(request, EntityAsMap.class));
        return Mono.from(response).flatMapMany(it -> Flux.fromIterable(DocumentAdapters.from((MgetResponse<EntityAsMap>)it))).flatMap(multiGetItem -> {
            if (multiGetItem.isFailed()) {
                return Mono.just(MultiGetItem.of(null, multiGetItem.getFailure()));
            }
            return callback.toEntity((Document)multiGetItem.getItem()).map(t -> MultiGetItem.of(t, multiGetItem.getFailure()));
        });
    }

    @Override
    protected ReactiveElasticsearchTemplate doCopy() {
        return new ReactiveElasticsearchTemplate(this.client, this.converter);
    }

    @Override
    protected Mono<Boolean> doExists(String id, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        GetRequest getRequest = this.requestConverter.documentGetRequest(id, this.routingResolver.getRouting(), index, true);
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.get(getRequest, EntityAsMap.class))).map(GetResult::found).onErrorReturn(NoSuchIndexException.class, (Object)false);
    }

    @Override
    public Mono<ByQueryResponse> delete(Query query, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        DeleteByQueryRequest request = this.requestConverter.documentDeleteByQueryRequest(query, entityType, index, this.getRefreshPolicy());
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.deleteByQuery(request))).map(this.responseConverter::byQueryResponse);
    }

    @Override
    protected Flux<SearchDocument> doFind(Query query, Class<?> clazz, IndexCoordinates index) {
        return Flux.defer(() -> {
            boolean useScroll = !query.getPageable().isPaged() && !query.isLimiting();
            SearchRequest searchRequest = this.requestConverter.searchRequest(query, clazz, index, false, useScroll);
            if (useScroll) {
                return this.doScroll(searchRequest);
            }
            return this.doFind(searchRequest);
        });
    }

    private Flux<SearchDocument> doScroll(SearchRequest searchRequest) {
        Time scrollTimeout = searchRequest.scroll() != null ? searchRequest.scroll() : Time.of(t -> t.time("1m"));
        Flux searchResponses = Flux.usingWhen((Publisher)Mono.fromSupplier(ScrollState::new), state -> Mono.from(this.execute((ReactiveElasticsearchClient client1) -> client1.search(searchRequest, EntityAsMap.class))).expand(entityAsMapSearchResponse -> {
            state.updateScrollId(entityAsMapSearchResponse.scrollId());
            if (entityAsMapSearchResponse.hits() == null || CollectionUtils.isEmpty((Collection)entityAsMapSearchResponse.hits().hits())) {
                return Mono.empty();
            }
            return Mono.from(this.execute((ReactiveElasticsearchClient client1) -> {
                ScrollRequest scrollRequest = ScrollRequest.of(sr -> sr.scrollId(state.getScrollId()).scroll(scrollTimeout));
                return client1.scroll(scrollRequest, EntityAsMap.class);
            }));
        }), this::cleanupScroll, (state, ex) -> this.cleanupScroll((ScrollState)state), this::cleanupScroll);
        return searchResponses.flatMapIterable(entityAsMapSearchResponse -> entityAsMapSearchResponse.hits().hits()).map(entityAsMapHit -> DocumentAdapters.from(entityAsMapHit, this.jsonpMapper));
    }

    private Publisher<?> cleanupScroll(ScrollState state) {
        return this.execute((ReactiveElasticsearchClient client) -> client.clearScroll(ClearScrollRequest.of(csr -> csr.scrollId(state.getScrollIds()))));
    }

    @Override
    protected Mono<Long> doCount(Query query, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        SearchRequest searchRequest = this.requestConverter.searchRequest(query, entityType, index, true, false);
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.search(searchRequest, EntityAsMap.class))).map(searchResponse -> searchResponse.hits().total() != null ? searchResponse.hits().total().value() : 0L);
    }

    private Flux<SearchDocument> doFind(SearchRequest searchRequest) {
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.search(searchRequest, EntityAsMap.class))).flatMapIterable(entityAsMapSearchResponse -> entityAsMapSearchResponse.hits().hits()).map(entityAsMapHit -> DocumentAdapters.from(entityAsMapHit, this.jsonpMapper));
    }

    @Override
    protected <T> Mono<SearchDocumentResponse> doFindForResponse(Query query, Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        SearchRequest searchRequest = this.requestConverter.searchRequest(query, clazz, index, false, false);
        AbstractReactiveElasticsearchTemplate.ReadSearchDocumentCallback callback = new AbstractReactiveElasticsearchTemplate.ReadSearchDocumentCallback(clazz, index);
        SearchDocumentResponse.EntityCreator entityCreator = searchDocument -> callback.toEntity((SearchDocument)searchDocument).toFuture();
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.search(searchRequest, EntityAsMap.class))).map(searchResponse -> SearchDocumentResponseBuilder.from((ResponseBody<EntityAsMap>)searchResponse, entityCreator, this.jsonpMapper));
    }

    @Override
    public Flux<? extends AggregationContainer<?>> aggregate(Query query, Class<?> entityType, IndexCoordinates index) {
        return this.doFindForResponse(query, entityType, index).flatMapMany(searchDocumentResponse -> {
            ElasticsearchAggregations aggregations = (ElasticsearchAggregations)searchDocumentResponse.getAggregations();
            return aggregations == null ? Flux.empty() : Flux.fromIterable((Iterable)aggregations.aggregations());
        });
    }

    @Override
    public Mono<String> openPointInTime(IndexCoordinates index, Duration keepAlive, Boolean ignoreUnavailable) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull((Object)keepAlive, (String)"keepAlive must not be null");
        Assert.notNull((Object)ignoreUnavailable, (String)"ignoreUnavailable must not be null");
        OpenPointInTimeRequest request = this.requestConverter.searchOpenPointInTimeRequest(index, keepAlive, ignoreUnavailable);
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.openPointInTime(request))).map(OpenPointInTimeResponse::id);
    }

    @Override
    public Mono<Boolean> closePointInTime(String pit) {
        Assert.notNull((Object)pit, (String)"pit must not be null");
        ClosePointInTimeRequest request = this.requestConverter.searchClosePointInTime(pit);
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.closePointInTime(request))).map(ClosePointInTimeResponse::succeeded);
    }

    @Override
    public Mono<String> getVendor() {
        return Mono.just((Object)"Elasticsearch");
    }

    @Override
    public Mono<String> getRuntimeLibraryVersion() {
        return Mono.just((Object)(Version.VERSION != null ? Version.VERSION.toString() : "null"));
    }

    @Override
    public Mono<String> getClusterVersion() {
        return Mono.from(this.execute((ReactiveElasticsearchClient reactiveElasticsearchClient) -> {
            try (ApiTypeHelper.DisabledChecksHandle ignored = ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck((boolean)true);){
                Mono<InfoResponse> mono = reactiveElasticsearchClient.info();
                return mono;
            }
        })).map(infoResponse -> infoResponse.version().number());
    }

    @Override
    public Mono<UpdateResponse> update(UpdateQuery updateQuery, IndexCoordinates index) {
        Assert.notNull((Object)updateQuery, (String)"UpdateQuery must not be null");
        Assert.notNull((Object)index, (String)"Index must not be null");
        UpdateRequest<Document, ?> request = this.requestConverter.documentUpdateRequest(updateQuery, index, this.getRefreshPolicy(), this.routingResolver.getRouting());
        return Mono.from(this.execute((ReactiveElasticsearchClient client) -> client.update(request, Document.class))).flatMap(response -> {
            UpdateResponse.Result result = TypeUtils.result(response.result());
            return result == null ? Mono.empty() : Mono.just((Object)UpdateResponse.of(result));
        });
    }

    @Override
    public Mono<ByQueryResponse> updateByQuery(UpdateQuery updateQuery, IndexCoordinates index) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    @Deprecated
    public <T> Publisher<T> execute(ReactiveElasticsearchOperations.ClientCallback<Publisher<T>> callback) {
        throw new UnsupportedBackendOperation("direct execution on the WebClient is not supported for this class");
    }

    @Override
    public <T> Publisher<T> executeWithIndicesClient(ReactiveElasticsearchOperations.IndicesClientCallback<Publisher<T>> callback) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <T> Publisher<T> executeWithClusterClient(ReactiveElasticsearchOperations.ClusterClientCallback<Publisher<T>> callback) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public ReactiveIndexOperations indexOps(IndexCoordinates index) {
        return new ReactiveIndicesTemplate(this.client.indices(), this.converter, index);
    }

    @Override
    public ReactiveIndexOperations indexOps(Class<?> clazz) {
        return new ReactiveIndicesTemplate(this.client.indices(), this.converter, clazz);
    }

    @Override
    public ReactiveClusterOperations cluster() {
        return new ReactiveClusterTemplate(this.client.cluster(), this.converter);
    }

    @Override
    public Query matchAllQuery() {
        return NativeQuery.builder().withQuery(QueryBuilders.matchAllQueryAsQuery()).build();
    }

    @Override
    public Query idsQuery(List<String> ids) {
        return NativeQuery.builder().withQuery(QueryBuilders.idsQueryAsQuery(ids)).build();
    }

    public <T> Publisher<T> execute(ClientCallback<Publisher<T>> callback) {
        return Flux.defer(() -> callback.doWithClient(this.client)).onErrorMap(this::translateException);
    }

    private RuntimeException translateException(Throwable throwable) {
        RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable.getMessage(), throwable);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }

    static interface ClientCallback<T extends Publisher<?>> {
        public T doWithClient(ReactiveElasticsearchClient var1);
    }
}

