/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.ExistsTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsRequest;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsResponse;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingResponse;
import co.elastic.clients.elasticsearch.indices.GetTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetTemplateResponse;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesRequest;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.client.elc.ReactiveChildTemplate;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchIndicesClient;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.ReactiveResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ReactiveMappingBuilder;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveIndicesTemplate
extends ReactiveChildTemplate<ElasticsearchTransport, ReactiveElasticsearchIndicesClient>
implements ReactiveIndexOperations {
    @Nullable
    private final Class<?> boundClass;
    private final IndexCoordinates boundIndexCoordinates;

    public ReactiveIndicesTemplate(ReactiveElasticsearchIndicesClient client, ElasticsearchConverter elasticsearchConverter, IndexCoordinates index) {
        super(client, elasticsearchConverter);
        Assert.notNull((Object)index, (String)"index must not be null");
        this.boundClass = null;
        this.boundIndexCoordinates = index;
    }

    public ReactiveIndicesTemplate(ReactiveElasticsearchIndicesClient client, ElasticsearchConverter elasticsearchConverter, Class<?> clazz) {
        super(client, elasticsearchConverter);
        Assert.notNull(clazz, (String)"clazz must not be null");
        this.boundClass = clazz;
        this.boundIndexCoordinates = this.getIndexCoordinatesFor(clazz);
    }

    @Override
    public Mono<Boolean> create() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        if (this.boundClass != null) {
            return this.createSettings(this.boundClass).flatMap(settings -> this.doCreate(indexCoordinates, (Map<String, Object>)settings, null));
        }
        return this.doCreate(indexCoordinates, new Settings(), null);
    }

    @Override
    public Mono<Boolean> create(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    @Override
    public Mono<Boolean> create(Map<String, Object> settings, Document mapping) {
        Assert.notNull(settings, (String)"settings must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, mapping);
    }

    @Override
    public Mono<Boolean> createWithMapping() {
        return this.createSettings().flatMap(settings -> this.createMapping().flatMap(mapping -> this.doCreate(this.getIndexCoordinates(), (Map<String, Object>)settings, (Document)mapping)));
    }

    private Mono<Boolean> doCreate(IndexCoordinates indexCoordinates, Map<String, Object> settings, @Nullable Document mapping) {
        CreateIndexRequest createIndexRequest = this.requestConverter.indicesCreateRequest(indexCoordinates, settings, mapping);
        Mono createIndexResponse = Mono.from(this.execute(client -> client.create(createIndexRequest)));
        return createIndexResponse.map(CreateIndexResponse::acknowledged);
    }

    @Override
    public Mono<Boolean> delete() {
        return this.exists().flatMap(exists -> {
            if (exists.booleanValue()) {
                DeleteIndexRequest deleteIndexRequest = this.requestConverter.indicesDeleteRequest(this.getIndexCoordinates());
                return Mono.from(this.execute(client -> client.delete(deleteIndexRequest))).map(AcknowledgedResponseBase::acknowledged).onErrorResume(NoSuchIndexException.class, e -> Mono.just((Object)false));
            }
            return Mono.just((Object)false);
        });
    }

    @Override
    public Mono<Boolean> exists() {
        ExistsRequest existsRequest = this.requestConverter.indicesExistsRequest(this.getIndexCoordinates());
        Mono existsResponse = Mono.from(this.execute(client -> client.exists(existsRequest)));
        return existsResponse.map(BooleanResponse::value);
    }

    @Override
    public Mono<Void> refresh() {
        RefreshRequest refreshRequest = this.requestConverter.indicesRefreshRequest(this.getIndexCoordinates());
        return Mono.from(this.execute(client -> client.refresh(refreshRequest))).then();
    }

    @Override
    public Mono<Document> createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    @Override
    public Mono<Document> createMapping(Class<?> clazz) {
        String mappingPath;
        Assert.notNull(clazz, (String)"clazz must not be null");
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null && StringUtils.hasText((String)(mappingPath = mappingAnnotation.mappingPath()))) {
            return ReactiveResourceUtil.loadDocument(mappingAnnotation.mappingPath(), "@Mapping");
        }
        return new ReactiveMappingBuilder(this.elasticsearchConverter).buildReactivePropertyMapping(clazz).map(Document::parse);
    }

    @Override
    public Mono<Boolean> putMapping(Mono<Document> mapping) {
        Assert.notNull(mapping, (String)"mapping must not be null");
        Mono putMappingResponse = mapping.map(document -> this.requestConverter.indicesPutMappingRequest(this.getIndexCoordinates(), (Document)document)).flatMap(putMappingRequest -> Mono.from(((ReactiveElasticsearchIndicesClient)this.client).putMapping((PutMappingRequest)putMappingRequest)));
        return putMappingResponse.map(AcknowledgedResponseBase::acknowledged);
    }

    @Override
    public Mono<Document> getMapping() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        GetMappingRequest getMappingRequest = this.requestConverter.indicesGetMappingRequest(indexCoordinates);
        Mono getMappingResponse = Mono.from(this.execute(client -> client.getMapping(getMappingRequest)));
        return getMappingResponse.map(response -> this.responseConverter.indicesGetMapping((GetMappingResponse)response, indexCoordinates));
    }

    @Override
    public Mono<Settings> createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    @Override
    public Mono<Settings> createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
        String settingPath = persistentEntity.settingPath();
        return StringUtils.hasText((String)settingPath) ? ReactiveResourceUtil.loadDocument(settingPath, "@Setting").map(Settings::new) : Mono.just((Object)persistentEntity.getDefaultSettings());
    }

    @Override
    public Mono<Settings> getSettings(boolean includeDefaults) {
        GetIndicesSettingsRequest getSettingsRequest = this.requestConverter.indicesGetSettingsRequest(this.getIndexCoordinates(), includeDefaults);
        Mono getSettingsResponse = Mono.from(this.execute(client -> client.getSettings(getSettingsRequest)));
        return getSettingsResponse.map(response -> this.responseConverter.indicesGetSettings((GetIndicesSettingsResponse)response, this.getIndexCoordinates().getIndexName()));
    }

    @Override
    public Mono<Boolean> alias(AliasActions aliasActions) {
        Assert.notNull((Object)aliasActions, (String)"aliasActions must not be null");
        UpdateAliasesRequest updateAliasesRequest = this.requestConverter.indicesUpdateAliasesRequest(aliasActions);
        Mono updateAliasesResponse = Mono.from(this.execute(client -> client.updateAliases(updateAliasesRequest)));
        return updateAliasesResponse.map(AcknowledgedResponseBase::acknowledged);
    }

    @Override
    public Mono<Map<String, Set<AliasData>>> getAliases(String ... aliasNames) {
        return this.getAliases(aliasNames, (String[])null);
    }

    @Override
    public Mono<Map<String, Set<AliasData>>> getAliasesForIndex(String ... indexNames) {
        return this.getAliases((String[])null, indexNames);
    }

    private Mono<Map<String, Set<AliasData>>> getAliases(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasRequest getAliasRequest = this.requestConverter.indicesGetAliasRequest(aliasNames, indexNames);
        Mono getAliasResponse = Mono.from(this.execute(client -> client.getAlias(getAliasRequest)));
        return getAliasResponse.map(this.responseConverter::indicesGetAliasData);
    }

    @Override
    public Mono<Boolean> putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        co.elastic.clients.elasticsearch.indices.PutTemplateRequest putTemplateRequestES = this.requestConverter.indicesPutTemplateRequest(putTemplateRequest);
        Mono putTemplateResponse = Mono.from(this.execute(client -> client.putTemplate(putTemplateRequestES)));
        return putTemplateResponse.map(AcknowledgedResponseBase::acknowledged);
    }

    @Override
    public Mono<TemplateData> getTemplate(org.springframework.data.elasticsearch.core.index.GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        GetTemplateRequest getTemplateRequestES = this.requestConverter.indicesGetTemplateRequest(getTemplateRequest);
        Mono getTemplateResponse = Mono.from(this.execute(client -> client.getTemplate(getTemplateRequestES)));
        return getTemplateResponse.flatMap(response -> {
            TemplateData templateData;
            if (response != null && (templateData = this.responseConverter.indicesGetTemplateData((GetTemplateResponse)response, getTemplateRequest.getTemplateName())) != null) {
                return Mono.just((Object)templateData);
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Boolean> existsTemplate(org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        ExistsTemplateRequest existsTemplateRequestES = this.requestConverter.indicesExistsTemplateRequest(existsTemplateRequest);
        return Mono.from(this.execute(client -> client.existsTemplate(existsTemplateRequestES))).map(BooleanResponse::value);
    }

    @Override
    public Mono<Boolean> deleteTemplate(org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteTemplateRequest deleteTemplateRequestES = this.requestConverter.indicesDeleteTemplateRequest(deleteTemplateRequest);
        return Mono.from(this.execute(client -> client.deleteTemplate(deleteTemplateRequestES))).map(AcknowledgedResponseBase::acknowledged);
    }

    @Override
    public Flux<IndexInformation> getInformation(IndexCoordinates index) {
        GetIndexRequest request = this.requestConverter.indicesGetIndexRequest(index);
        return Mono.from(this.execute(client -> client.get(request))).map(this.responseConverter::indicesGetIndexInformations).flatMapMany(Flux::fromIterable);
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : Objects.requireNonNull(this.boundIndexCoordinates);
    }

    private IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return ((ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz)).getIndexCoordinates();
    }

    private Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }
}

