/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.AbstractReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.IndexOperationsAdapter;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.routing.RoutingResolver;
import org.springframework.data.elasticsearch.repository.ReactiveElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveElasticsearchRepository<T, ID>
implements ReactiveElasticsearchRepository<T, ID> {
    private final ElasticsearchEntityInformation<T, ID> entityInformation;
    private final ReactiveElasticsearchOperations operations;
    private final ReactiveIndexOperations indexOperations;

    public SimpleReactiveElasticsearchRepository(ElasticsearchEntityInformation<T, ID> entityInformation, ReactiveElasticsearchOperations operations) {
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)operations, (String)"ElasticsearchOperations must not be null!");
        this.entityInformation = entityInformation;
        this.operations = operations;
        this.indexOperations = operations.indexOps(entityInformation.getJavaType());
        if (!"true".equals(System.getenv("SPRING_DATA_ELASTICSEARCH_SKIP_REPOSITORY_INIT"))) {
            this.createIndexAndMappingIfNeeded();
        }
    }

    public void createIndexAndMappingIfNeeded() {
        IndexOperationsAdapter blockingIndexOperations = IndexOperationsAdapter.blocking(this.indexOperations);
        if (this.shouldCreateIndexAndMapping()) {
            if (!blockingIndexOperations.exists()) {
                blockingIndexOperations.createWithMapping();
            }
        } else if (this.shouldAlwaysWriteMapping()) {
            blockingIndexOperations.putMapping();
        }
    }

    private boolean shouldCreateIndexAndMapping() {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityInformation.getJavaType());
        return entity.isCreateIndexAndMapping();
    }

    private boolean shouldAlwaysWriteMapping() {
        return ((ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityInformation.getJavaType())).isAlwaysWriteMapping();
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.save(entity, this.entityInformation.getIndexCoordinates()).flatMap(saved -> this.doRefresh().thenReturn(saved));
    }

    @Override
    public <S extends T> Mono<S> save(S entity, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.withRefreshPolicy(refreshPolicy).save(entity, this.entityInformation.getIndexCoordinates()).flatMap(saved -> this.doRefresh().thenReturn(saved));
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.saveAll((Publisher<S>)Flux.fromIterable(entities));
    }

    @Override
    public <S extends T> Flux<S> saveAll(Iterable<S> entities, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.saveAll((Publisher<S>)Flux.fromIterable(entities), refreshPolicy);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return this.operations.save(Flux.from(entityStream), this.entityInformation.getIndexCoordinates()).concatWith((Publisher)this.doRefresh().then(Mono.empty()));
    }

    @Override
    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return this.operations.withRefreshPolicy(refreshPolicy).save(Flux.from(entityStream), this.entityInformation.getIndexCoordinates()).concatWith((Publisher)this.doRefresh().then(Mono.empty()));
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.get(this.convertId(id), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates());
    }

    public Mono<T> findById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.exists(this.convertId(id), this.entityInformation.getIndexCoordinates());
    }

    public Mono<Boolean> existsById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        return this.operations.search((Query)Query.findAll().setPageable(Pageable.unpaged()), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).map(SearchHit::getContent);
    }

    public Flux<T> findAll(Sort sort) {
        return this.operations.search((Query)Query.findAll().addSort(sort).setPageable(Pageable.unpaged()), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).map(SearchHit::getContent);
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(ids));
    }

    public Flux<T> findAllById(Publisher<ID> idStream) {
        Assert.notNull(idStream, (String)"IdStream must not be null!");
        return Flux.from(idStream).map(this::convertId).collectList().map(ids -> {
            BaseQuery query = new BaseQuery();
            query.setIds((Collection<String>)ids);
            return query;
        }).flatMapMany(query -> {
            IndexCoordinates index = this.entityInformation.getIndexCoordinates();
            return this.operations.multiGet((Query)query, this.entityInformation.getJavaType(), index).filter(MultiGetItem::hasItem).map(MultiGetItem::getItem);
        });
    }

    public Mono<Long> count() {
        return this.operations.count(Query.findAll(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates());
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.delete(this.convertId(id), this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    @Override
    public Mono<Void> deleteById(ID id, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.withRefreshPolicy(refreshPolicy).delete(this.convertId(id), this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    public Mono<Void> deleteById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::deleteById);
    }

    @Override
    public Mono<Void> deleteById(Publisher<ID> id, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(id2 -> this.deleteById(id, refreshPolicy));
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        String routing = this.operations.getEntityRouting(entity);
        ReactiveElasticsearchOperations ops = routing != null ? this.operations.withRouting(RoutingResolver.just(routing)) : this.operations;
        return ops.delete(entity, this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    @Override
    public Mono<Void> delete(T entity, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        String routing = this.operations.getEntityRouting(entity);
        ReactiveElasticsearchOperations ops = routing != null ? this.operations.withRouting(RoutingResolver.just(routing)) : this.operations;
        return ops.withRefreshPolicy(refreshPolicy).delete(entity, this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        return Flux.fromIterable(ids).map(this::convertId).collectList().map(this.operations::idsQuery).flatMap(query -> this.operations.delete(DeleteQuery.builder(query).build(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates())).then(this.doRefresh());
    }

    @Override
    public Mono<Void> deleteAllById(Iterable<? extends ID> ids, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        ReactiveElasticsearchOperations operationsWithRefreshPolicy = this.operations.withRefreshPolicy(refreshPolicy);
        return Flux.fromIterable(ids).map(this::convertId).collectList().map(this.operations::idsQuery).flatMap(query -> operationsWithRefreshPolicy.delete(DeleteQuery.builder(query).build(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates())).then(this.doRefresh());
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(entities));
    }

    @Override
    public Mono<Void> deleteAll(Iterable<? extends T> entities, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(entities), refreshPolicy);
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return Flux.from(entityStream).map(arg_0 -> this.entityInformation.getRequiredId(arg_0)).map(this::convertId).collectList().map(this.operations::idsQuery).flatMap(query -> this.operations.delete(DeleteQuery.builder(query).build(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates())).then(this.doRefresh());
    }

    @Override
    public Mono<Void> deleteAll(Publisher<? extends T> entityStream, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        ReactiveElasticsearchOperations operationsWithRefreshPolicy = this.operations.withRefreshPolicy(refreshPolicy);
        return Flux.from(entityStream).map(arg_0 -> this.entityInformation.getRequiredId(arg_0)).map(this::convertId).collectList().map(this.operations::idsQuery).flatMap(query -> operationsWithRefreshPolicy.delete(DeleteQuery.builder(query).build(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates())).then(this.doRefresh());
    }

    public Mono<Void> deleteAll() {
        return this.operations.delete(DeleteQuery.builder(Query.findAll()).build(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    @Override
    public Mono<Void> deleteAll(@Nullable RefreshPolicy refreshPolicy) {
        return this.operations.withRefreshPolicy(refreshPolicy).delete(DeleteQuery.builder(Query.findAll()).build(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    private String convertId(Object id) {
        return this.operations.getElasticsearchConverter().convertId(id);
    }

    private Mono<Void> doRefresh() {
        RefreshPolicy refreshPolicy = null;
        ReactiveElasticsearchOperations reactiveElasticsearchOperations = this.operations;
        if (reactiveElasticsearchOperations instanceof AbstractReactiveElasticsearchTemplate) {
            AbstractReactiveElasticsearchTemplate template = (AbstractReactiveElasticsearchTemplate)reactiveElasticsearchOperations;
            refreshPolicy = template.getRefreshPolicy();
        }
        if (refreshPolicy == null) {
            return this.indexOperations.refresh();
        }
        return Mono.empty();
    }
}

