/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.envers.repository.support.DefaultRevisionMetadata;
import org.springframework.data.envers.repository.support.EnversRevisionRepository;
import org.springframework.data.history.AnnotationRevisionMetadata;
import org.springframework.data.history.Revision;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.history.RevisionSort;
import org.springframework.data.history.Revisions;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.history.support.RevisionEntityInformation;
import org.springframework.util.Assert;

public class EnversRevisionRepositoryImpl<T, ID extends Serializable, N extends Number>
extends SimpleJpaRepository<T, ID>
implements EnversRevisionRepository<T, ID, N> {
    private final EntityInformation<T, ?> entityInformation;
    private final RevisionEntityInformation revisionEntityInformation;
    private final EntityManager entityManager;

    public EnversRevisionRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, RevisionEntityInformation revisionEntityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        Assert.notNull((Object)revisionEntityInformation);
        this.entityInformation = entityInformation;
        this.revisionEntityInformation = revisionEntityInformation;
        this.entityManager = entityManager;
    }

    public Revision<N, T> findLastChangeRevision(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisions = reader.getRevisions(type, id);
        if (revisions.isEmpty()) {
            return null;
        }
        Number latestRevision = (Number)revisions.get(revisions.size() - 1);
        Class revisionEntityClass = this.revisionEntityInformation.getRevisionEntityClass();
        Object revisionEntity = reader.findRevision(revisionEntityClass, latestRevision);
        RevisionMetadata<?> metadata = this.getRevisionMetadata(revisionEntity);
        return new Revision(metadata, reader.find(type, id, latestRevision));
    }

    public Revision<N, T> findRevision(ID id, N revisionNumber) {
        Assert.notNull(id, (String)"Identifier must not be null!");
        Assert.notNull(revisionNumber, (String)"Revision number must not be null!");
        return this.getEntityForRevision(revisionNumber, id, AuditReaderFactory.get((EntityManager)this.entityManager));
    }

    public Revisions<N, T> findRevisions(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        return revisionNumbers.isEmpty() ? new Revisions<N, T>(Collections.EMPTY_LIST) : this.getEntitiesForRevisions(revisionNumbers, id, reader);
    }

    public Page<Revision<N, T>> findRevisions(ID id, Pageable pageable) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        boolean isDescending = RevisionSort.getRevisionDirection((Sort)pageable.getSort()).isDescending();
        if (isDescending) {
            Collections.reverse(revisionNumbers);
        }
        if (pageable.getOffset() > revisionNumbers.size()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        int upperBound = pageable.getOffset() + pageable.getPageSize();
        upperBound = upperBound > revisionNumbers.size() ? revisionNumbers.size() : upperBound;
        List subList = revisionNumbers.subList(pageable.getOffset(), upperBound);
        Revisions revisions = this.getEntitiesForRevisions(subList, id, reader);
        revisions = isDescending ? revisions.reverse() : revisions;
        return new PageImpl(revisions.getContent(), pageable, (long)revisionNumbers.size());
    }

    private Revisions<N, T> getEntitiesForRevisions(List<N> revisionNumbers, ID id, AuditReader reader) {
        Class type = this.entityInformation.getJavaType();
        HashMap<Number, Object> revisions = new HashMap<Number, Object>(revisionNumbers.size());
        Class revisionEntityClass = this.revisionEntityInformation.getRevisionEntityClass();
        Map revisionEntities = reader.findRevisions(revisionEntityClass, new HashSet<N>(revisionNumbers));
        for (Number number : revisionNumbers) {
            revisions.put(number, reader.find(type, id, number));
        }
        return new Revisions(this.toRevisions(revisions, revisionEntities));
    }

    private Revision<N, T> getEntityForRevision(N revisionNumber, ID id, AuditReader reader) {
        Class type = this.revisionEntityInformation.getRevisionEntityClass();
        Object revision = reader.findRevision(type, revisionNumber);
        Object entity = reader.find(this.entityInformation.getJavaType(), id, revisionNumber);
        return new Revision(this.getRevisionMetadata(revision), entity);
    }

    private List<Revision<N, T>> toRevisions(Map<N, T> source, Map<Number, Object> revisionEntities) {
        ArrayList<Revision> result = new ArrayList<Revision>();
        for (Map.Entry<N, T> revision : source.entrySet()) {
            Number revisionNumber = (Number)revision.getKey();
            T entity = revision.getValue();
            RevisionMetadata<?> metadata = this.getRevisionMetadata(revisionEntities.get(revisionNumber));
            result.add(new Revision(metadata, entity));
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    private RevisionMetadata<?> getRevisionMetadata(Object object) {
        if (object instanceof DefaultRevisionEntity) {
            return new DefaultRevisionMetadata((DefaultRevisionEntity)object);
        }
        return new AnnotationRevisionMetadata(object, RevisionNumber.class, RevisionTimestamp.class);
    }
}

