/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactoryBean
implements BeanNameAware,
BeanFactoryAware,
BeanClassLoaderAware,
DisposableBean,
InitializingBean,
FactoryBean<GemFireCache>,
PersistenceExceptionTranslator {
    protected final Log log = LogFactory.getLog(this.getClass());
    private GemFireCache cache;
    private Resource cacheXml;
    private Properties properties;
    private ClassLoader beanClassLoader;
    private GemfireBeanFactoryLocator factoryLocator;
    private BeanFactory beanFactory;
    private String beanName;
    private boolean useBeanFactoryLocator = true;
    protected Object pdxSerializer;
    protected Boolean pdxPersistent;
    protected Boolean pdxReadSerialized;
    protected Boolean pdxIgnoreUnreadFields;
    protected String pdxDiskStoreName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.useBeanFactoryLocator) {
            this.factoryLocator = new GemfireBeanFactoryLocator();
            this.factoryLocator.setBeanFactory(this.beanFactory);
            this.factoryLocator.setBeanName(this.beanName);
            this.factoryLocator.afterPropertiesSet();
        }
        Properties cfgProps = this.mergeProperties();
        Thread th = Thread.currentThread();
        ClassLoader oldTCCL = th.getContextClassLoader();
        try {
            th.setContextClassLoader(this.beanClassLoader);
            String msg = null;
            try {
                this.cache = this.fetchCache();
                msg = "Retrieved existing";
            }
            catch (CacheClosedException ex) {
                Object factory = this.createFactory(cfgProps);
                if (this.pdxSerializer != null || this.pdxPersistent != null || this.pdxReadSerialized != null || this.pdxIgnoreUnreadFields != null || this.pdxDiskStoreName != null) {
                    Assert.isTrue((boolean)ClassUtils.isPresent((String)"com.gemstone.gemfire.pdx.PdxSerializer", (ClassLoader)this.beanClassLoader), (String)"Cannot set PDX options since GemFire 6.6 not detected");
                    this.applyPdxOptions(factory);
                }
                this.cache = this.createCache(factory);
                msg = "Created";
            }
            DistributedSystem system = this.cache.getDistributedSystem();
            DistributedMember member = system.getDistributedMember();
            this.log.info((Object)("Connected to Distributed System [" + system.getName() + "=" + member.getId() + "@" + member.getHost() + "]"));
            this.log.info((Object)(msg + " GemFire v." + CacheFactory.getVersion() + " Cache [" + this.cache.getName() + "]"));
            if (this.cacheXml != null) {
                this.cache.loadCacheXml(this.cacheXml.getInputStream());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initialized cache from " + this.cacheXml));
                }
            }
        }
        finally {
            th.setContextClassLoader(oldTCCL);
        }
    }

    protected void applyPdxOptions(Object factory) {
        if (factory instanceof CacheFactory) {
            new PdxOptions((CacheFactory)factory).run();
        }
    }

    protected Object createFactory(Properties props) {
        return new CacheFactory(props);
    }

    protected GemFireCache fetchCache() {
        return CacheFactory.getAnyInstance();
    }

    protected GemFireCache createCache(Object factory) {
        return ((CacheFactory)factory).create();
    }

    protected Properties mergeProperties() {
        Properties cfgProps = this.properties != null ? (Properties)this.properties.clone() : new Properties();
        return cfgProps;
    }

    public void destroy() throws Exception {
        if (this.cache != null && !this.cache.isClosed()) {
            this.cache.close();
        }
        this.cache = null;
        if (this.factoryLocator != null) {
            this.factoryLocator.destroy();
            this.factoryLocator = null;
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        DataAccessException wrapped;
        if (ex instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)ex);
        }
        if (ex instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(ex)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        return null;
    }

    public GemFireCache getObject() throws Exception {
        return this.cache;
    }

    public Class<? extends GemFireCache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    public void setUseBeanFactoryLocator(boolean usage) {
        this.useBeanFactoryLocator = usage;
    }

    public void setPdxSerializer(Object serializer) {
        this.pdxSerializer = serializer;
    }

    public void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    public void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    public void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    public void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    private class PdxOptions
    implements Runnable {
        private CacheFactory factory;

        PdxOptions(CacheFactory factory) {
            this.factory = factory;
        }

        public void run() {
            if (CacheFactoryBean.this.pdxSerializer != null) {
                Assert.isAssignable(PdxSerializer.class, CacheFactoryBean.this.pdxSerializer.getClass(), (String)"Invalid pdx serializer used");
                this.factory.setPdxSerializer((PdxSerializer)CacheFactoryBean.this.pdxSerializer);
            }
            if (CacheFactoryBean.this.pdxDiskStoreName != null) {
                this.factory.setPdxDiskStore(CacheFactoryBean.this.pdxDiskStoreName);
            }
            if (CacheFactoryBean.this.pdxIgnoreUnreadFields != null) {
                this.factory.setPdxIgnoreUnreadFields(CacheFactoryBean.this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (CacheFactoryBean.this.pdxPersistent != null) {
                this.factory.setPdxPersistent(CacheFactoryBean.this.pdxPersistent.booleanValue());
            }
            if (CacheFactoryBean.this.pdxReadSerialized != null) {
                this.factory.setPdxReadSerialized(CacheFactoryBean.this.pdxReadSerialized.booleanValue());
            }
        }
    }
}

