/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryService;
import java.util.Collection;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFactoryBean
implements InitializingBean,
BeanNameAware,
FactoryBean<Index> {
    private Index index;
    private QueryService queryService;
    private String poolName;
    private RegionService cache;
    private String beanName;
    private String name;
    private String expression;
    private String from;
    private String imports;
    private IndexType type = IndexType.FUNCTIONAL;
    private boolean override = true;

    public void afterPropertiesSet() throws Exception {
        if (this.queryService == null && this.cache != null) {
            this.queryService = this.cache.getQueryService();
        }
        if (this.queryService != null && StringUtils.hasText((String)this.poolName)) {
            Pool pool = PoolManager.find((String)this.poolName);
            Assert.notNull((Object)pool, (String)("No pool named [" + this.poolName + "] found"));
            this.queryService = pool.getQueryService();
        }
        Assert.notNull((Object)this.queryService, (String)"Query service required for index creation");
        Assert.hasText((String)this.expression, (String)"Index expression is required");
        Assert.hasText((String)this.from, (String)"Index from clause is required");
        String indexName = StringUtils.hasText((String)this.name) ? this.name : this.beanName;
        Assert.hasText((String)indexName, (String)"Index bean id or name is required");
        this.index = this.createIndex(this.queryService, indexName);
    }

    private Index createIndex(QueryService queryService, String indexName) throws Exception {
        Collection indexes = queryService.getIndexes();
        Index old = null;
        for (Index index : indexes) {
            if (!indexName.equals(index.getName())) continue;
            if (!this.override) {
                return index;
            }
            old = index;
            break;
        }
        if (old != null && this.from.equals(old.getFromClause()) && this.expression.equals(old.getIndexedExpression()) && this.type.equals(old.getType())) {
            return this.index;
        }
        Index index = null;
        index = StringUtils.hasText((String)this.imports) ? queryService.createIndex(indexName, this.type, this.expression, this.from, this.imports) : queryService.createIndex(indexName, this.type, this.expression, this.from);
        return index;
    }

    public Index getObject() {
        return this.index;
    }

    public Class<?> getObjectType() {
        return this.index != null ? this.index.getClass() : Index.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCache(RegionService cache) {
        this.queryService = cache.getQueryService();
    }

    public void setQueryService(QueryService service) {
        this.queryService = service;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public void setType(IndexType type) {
        this.type = type;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

