/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements BeanFactoryAware,
DisposableBean {
    private static final Log log = LogFactory.getLog(ClientRegionFactoryBean.class);
    private boolean destroy = false;
    private boolean close = true;
    private Resource snapshot;
    private CacheListener<K, V>[] cacheListeners;
    private Interest<K>[] interests;
    private String poolName;
    private BeanFactory beanFactory;
    private ClientRegionShortcut shortcut = null;
    private DataPolicy dataPolicy;
    private RegionAttributes<K, V> attributes;
    private Region<K, V> region;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.region = this.getRegion();
        this.postProcess(this.region);
    }

    @Override
    protected Region<K, V> lookupFallback(GemFireCache cache, String regionName) throws Exception {
        Assert.isTrue((boolean)(cache instanceof ClientCache), (String)("Unable to create regions from " + cache));
        ClientCache c = (ClientCache)cache;
        if (cache instanceof GemFireCacheImpl) {
            Assert.isTrue((boolean)((GemFireCacheImpl)cache).isClient(), (String)"A client-cache instance is required");
        }
        ClientRegionShortcut s = null;
        s = this.shortcut == null ? (this.dataPolicy != null ? (DataPolicy.EMPTY.equals(this.dataPolicy) ? ClientRegionShortcut.PROXY : (DataPolicy.PERSISTENT_REPLICATE.equals(this.dataPolicy) ? ClientRegionShortcut.LOCAL_PERSISTENT : (DataPolicy.NORMAL.equals(this.dataPolicy) ? ClientRegionShortcut.CACHING_PROXY : ClientRegionShortcut.LOCAL))) : ClientRegionShortcut.LOCAL) : this.shortcut;
        ClientRegionFactory factory = c.createClientRegionFactory(s);
        if (this.attributes != null) {
            Object[] listeners = this.attributes.getCacheListeners();
            if (!ObjectUtils.isEmpty((Object[])listeners)) {
                for (Object listener : listeners) {
                    factory.addCacheListener((CacheListener)listener);
                }
            }
            factory.setCloningEnabled(this.attributes.getCloningEnabled());
            factory.setConcurrencyLevel(this.attributes.getConcurrencyLevel());
            factory.setCustomEntryIdleTimeout(this.attributes.getCustomEntryIdleTimeout());
            factory.setCustomEntryTimeToLive(this.attributes.getCustomEntryTimeToLive());
            factory.setDiskStoreName(this.attributes.getDiskStoreName());
            factory.setDiskSynchronous(this.attributes.isDiskSynchronous());
            factory.setEntryIdleTimeout(this.attributes.getEntryIdleTimeout());
            factory.setEntryTimeToLive(this.attributes.getEntryTimeToLive());
            factory.setEvictionAttributes(this.attributes.getEvictionAttributes());
            factory.setInitialCapacity(this.attributes.getInitialCapacity());
            factory.setKeyConstraint(this.attributes.getKeyConstraint());
            factory.setLoadFactor(this.attributes.getLoadFactor());
            factory.setPoolName(this.attributes.getPoolName());
            factory.setRegionIdleTimeout(this.attributes.getRegionIdleTimeout());
            factory.setRegionTimeToLive(this.attributes.getRegionTimeToLive());
            factory.setStatisticsEnabled(this.attributes.getStatisticsEnabled());
            factory.setValueConstraint(this.attributes.getValueConstraint());
        }
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (CacheListener<K, V> listener : this.cacheListeners) {
                factory.addCacheListener(listener);
            }
        }
        if (StringUtils.hasText((String)this.poolName)) {
            if (this.beanFactory.isTypeMatch(this.poolName, Pool.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found bean definition for pool '" + this.poolName + "'. Eagerly initializing it..."));
                }
                this.beanFactory.getBean(this.poolName, Pool.class);
            }
            factory.setPoolName(this.poolName);
        }
        Region reg = factory.create(regionName);
        log.info((Object)("Created new cache region [" + regionName + "]"));
        if (this.snapshot != null) {
            reg.loadSnapshot(this.snapshot.getInputStream());
        }
        return reg;
    }

    protected void postProcess(Region<K, V> region) {
        if (!ObjectUtils.isEmpty((Object[])this.interests)) {
            for (Interest<K> interest : this.interests) {
                if (interest instanceof RegexInterest) {
                    region.registerInterestRegex((String)interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
                    continue;
                }
                region.registerInterest(interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            }
        }
    }

    public void destroy() throws Exception {
        Region region = this.getObject();
        try {
            if (region != null && !ObjectUtils.isEmpty((Object[])this.interests)) {
                for (Interest<K> interest : this.interests) {
                    if (interest instanceof RegexInterest) {
                        region.unregisterInterestRegex((String)interest.getKey());
                        continue;
                    }
                    region.unregisterInterest(interest.getKey());
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            log.warn((Object)"Cannot unregister cache interests", (Throwable)ex);
        }
        if (region != null) {
            if (this.close) {
                if (!region.getCache().isClosed()) {
                    try {
                        region.close();
                    }
                    catch (CacheClosedException cacheClosedException) {}
                }
            } else if (this.destroy) {
                region.destroyRegion();
            }
        }
        region = null;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setInterests(Interest<K>[] interests) {
        this.interests = interests;
    }

    Interest<K>[] getInterests() {
        return this.interests;
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"pool name is required");
        this.poolName = poolName;
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"pool cannot be null");
        this.setPoolName(pool.getName());
    }

    public void setShortcut(ClientRegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        if (destroy) {
            this.close = false;
        }
    }

    public void setClose(boolean close) {
        this.close = close;
        if (close) {
            this.destroy = false;
        }
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }
}

