/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.DataPolicy;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.data.gemfire.config.AliasReplacingBeanDefinitionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientRegionParser
extends AliasReplacingBeanDefinitionParser {
    ClientRegionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return ClientRegionFactoryBean.class;
    }

    @Override
    protected void doParseInternal(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        ParsingUtils.setPropertyValue(element, builder, "data-policy", "dataPolicy");
        ParsingUtils.setPropertyValue(element, builder, "name", "name");
        ParsingUtils.setPropertyValue(element, builder, "pool-name", "poolName");
        ParsingUtils.setPropertyValue(element, builder, "shortcut", "shortcut");
        String attr = element.getAttribute("persistent");
        boolean frozenDataPolicy = false;
        if (Boolean.parseBoolean(attr)) {
            builder.addPropertyValue("dataPolicy", (Object)DataPolicy.PERSISTENT_REPLICATE);
            frozenDataPolicy = true;
        }
        builder.addPropertyReference("cache", StringUtils.hasText((String)(attr = element.getAttribute("cache-ref"))) ? attr : "gemfire-cache");
        BeanDefinitionBuilder attrBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        ParsingUtils.parseStatistics(element, attrBuilder);
        boolean overwriteDataPolicy = false;
        overwriteDataPolicy |= ParsingUtils.parseEviction(parserContext, element, attrBuilder);
        if (!frozenDataPolicy && (overwriteDataPolicy |= ParsingUtils.parseDiskStorage(element, attrBuilder))) {
            builder.addPropertyValue("dataPolicy", (Object)DataPolicy.NORMAL);
        }
        builder.addPropertyValue("attributes", (Object)attrBuilder.getBeanDefinition());
        ManagedList interests = new ManagedList();
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            String name = subElement.getLocalName();
            if ("cache-listener".equals(name)) {
                builder.addPropertyValue("cacheListeners", this.parseCacheListener(parserContext, subElement, builder));
                continue;
            }
            if ("key-interest".equals(name)) {
                interests.add(this.parseKeyInterest(parserContext, subElement));
                continue;
            }
            if (!"regex-interest".equals(name)) continue;
            interests.add(this.parseRegexInterest(parserContext, subElement));
        }
        if (!subElements.isEmpty()) {
            builder.addPropertyValue("interests", (Object)interests);
        }
    }

    private Object parseCacheListener(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parseKeyInterest(ParserContext parserContext, Element subElement) {
        BeanDefinitionBuilder keyInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(Interest.class);
        this.parseCommonInterestAttr(subElement, keyInterestBuilder);
        Object key = ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, keyInterestBuilder, "key-ref");
        keyInterestBuilder.addConstructorArgValue(key);
        return keyInterestBuilder.getBeanDefinition();
    }

    private Object parseRegexInterest(ParserContext parserContext, Element subElement) {
        BeanDefinitionBuilder regexInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegexInterest.class);
        this.parseCommonInterestAttr(subElement, regexInterestBuilder);
        ParsingUtils.setPropertyValue(subElement, regexInterestBuilder, "pattern", "key");
        return regexInterestBuilder.getBeanDefinition();
    }

    private void parseCommonInterestAttr(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "durable", "durable");
        ParsingUtils.setPropertyValue(element, builder, "result-policy", "policy");
        ParsingUtils.setPropertyValue(element, builder, "receive-values", "receiveValues");
    }
}

