/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.data.gemfire.config.AliasReplacingBeanDefinitionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartitionedRegionParser
extends AliasReplacingBeanDefinitionParser {
    PartitionedRegionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return RegionFactoryBean.class;
    }

    @Override
    protected void doParseInternal(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        String attr = element.getAttribute("persistent");
        if (Boolean.parseBoolean(attr)) {
            if (ConcurrentMap.class.isAssignableFrom(Region.class)) {
                builder.addPropertyValue("dataPolicy", (Object)"PERSISTENT_PARTITION");
            } else {
                parserContext.getReaderContext().error("Can define persistent partitions only from GemFire 6.5 onwards - current version is [" + CacheFactory.getVersion() + "]", (Object)element);
            }
        } else {
            builder.addPropertyValue("dataPolicy", (Object)DataPolicy.PARTITION);
        }
        ParsingUtils.setPropertyValue(element, builder, "name", "name");
        attr = element.getAttribute("cache-ref");
        builder.addPropertyReference("cache", StringUtils.hasText((String)attr) ? attr : "gemfire-cache");
        BeanDefinitionBuilder attrBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        ParsingUtils.parseStatistics(element, attrBuilder);
        ParsingUtils.parseExpiration(parserContext, element, attrBuilder);
        ParsingUtils.parseEviction(parserContext, element, attrBuilder);
        ParsingUtils.parseDiskStorage(element, attrBuilder);
        BeanDefinitionBuilder parAttrBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
        attr = element.getAttribute("colocated-with");
        if (StringUtils.hasText((String)attr)) {
            parAttrBuilder.addPropertyValue("colocatedWith", (Object)attr);
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("local-max-memory")))) {
            parAttrBuilder.addPropertyValue("localMaxMemory", (Object)Integer.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("copies")))) {
            parAttrBuilder.addPropertyValue("redundantCopies", (Object)Integer.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("recovery-delay")))) {
            parAttrBuilder.addPropertyValue("recoveryDelay", (Object)Long.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("startup-recovery-delay")))) {
            parAttrBuilder.addPropertyValue("startupRecoveryDelay", (Object)Long.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("total-max-memory")))) {
            parAttrBuilder.addPropertyValue("totalMaxMemory", (Object)Long.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("total-buckets")))) {
            parAttrBuilder.addPropertyValue("totalNumBuckets", (Object)Integer.valueOf(attr));
        }
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            String name = subElement.getLocalName();
            if ("cache-listener".equals(name)) {
                builder.addPropertyValue("cacheListeners", this.parseCacheListener(parserContext, subElement, builder));
                continue;
            }
            if ("cache-loader".equals(name)) {
                builder.addPropertyValue("cacheLoader", this.parseCacheLoader(parserContext, subElement, builder));
                continue;
            }
            if ("cache-writer".equals(name)) {
                builder.addPropertyValue("cacheWriter", this.parseCacheWriter(parserContext, subElement, builder));
                continue;
            }
            if (!"partition-resolver".equals(name)) continue;
            parAttrBuilder.addPropertyValue("partitionResolver", this.parsePartitionResolver(parserContext, subElement, builder));
        }
        attrBuilder.addPropertyValue("partitionAttributes", (Object)parAttrBuilder.getBeanDefinition());
        builder.addPropertyValue("attributes", (Object)attrBuilder.getBeanDefinition());
    }

    private Object parseCacheListener(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parseCacheLoader(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parseCacheWriter(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parsePartitionResolver(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }
}

