/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiringInstantiator
extends Instantiator
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    private final Instantiator instantiator;
    private final Class<? extends DataSerializable> clazz;
    private BeanConfigurerSupport configurer;
    private BeanFactory beanFactory;
    private boolean autoRegister = true;
    private boolean distribute = false;

    public WiringInstantiator(Instantiator instantiator) {
        super(instantiator.getInstantiatedClass(), instantiator.getId());
        this.instantiator = instantiator;
        this.clazz = null;
    }

    public WiringInstantiator(Class<? extends DataSerializable> c, int classId) {
        super(c, classId);
        this.instantiator = null;
        this.clazz = c;
    }

    public void afterPropertiesSet() {
        if (this.configurer == null) {
            this.configurer = new BeanConfigurerSupport();
            this.configurer.setBeanFactory(this.beanFactory);
            this.configurer.afterPropertiesSet();
        }
        if (this.autoRegister) {
            Instantiator.register((Instantiator)this, (boolean)this.distribute);
        }
    }

    public void destroy() throws Exception {
        this.configurer.destroy();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public DataSerializable newInstance() {
        DataSerializable instance = this.createInstance();
        this.configurer.configureBean((Object)instance);
        return instance;
    }

    private DataSerializable createInstance() {
        if (this.instantiator != null) {
            return this.instantiator.newInstance();
        }
        return (DataSerializable)BeanUtils.instantiate(this.clazz);
    }

    public void setConfigurer(BeanConfigurerSupport configurer) {
        this.configurer = configurer;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setDistribute(boolean distribute) {
        this.distribute = distribute;
    }
}

