/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.config.EvictionType;

class EvictionAttributesFactoryBean
implements FactoryBean<EvictionAttributes>,
InitializingBean {
    private EvictionAttributes evictionAttr;
    private Integer threshold = null;
    private ObjectSizer objectSizer = null;
    private EvictionAction action = null;
    private EvictionType type = EvictionType.ENTRY_COUNT;

    EvictionAttributesFactoryBean() {
    }

    public void afterPropertiesSet() {
        if (this.action == null) {
            this.action = EvictionAction.DEFAULT_EVICTION_ACTION;
        }
        this.evictionAttr = this.createAttributes();
    }

    private EvictionAttributes createAttributes() {
        switch (this.type) {
            case HEAP_PERCENTAGE: {
                return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)this.objectSizer, (EvictionAction)this.action);
            }
            case MEMORY_SIZE: {
                if (this.threshold != null) {
                    return EvictionAttributes.createLRUMemoryAttributes((int)this.threshold, (ObjectSizer)this.objectSizer, (EvictionAction)this.action);
                }
                return EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)this.objectSizer, (EvictionAction)this.action);
            }
        }
        if (this.threshold != null) {
            return EvictionAttributes.createLRUEntryAttributes((int)this.threshold, (EvictionAction)this.action);
        }
        return EvictionAttributes.createLRUEntryAttributes();
    }

    public EvictionAttributes getObject() {
        return this.evictionAttr;
    }

    public Class<?> getObjectType() {
        return this.evictionAttr != null ? this.evictionAttr.getClass() : EvictionAttributes.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public ObjectSizer getObjectSizer() {
        return this.objectSizer;
    }

    public void setObjectSizer(ObjectSizer objectSizer) {
        this.objectSizer = objectSizer;
    }

    public EvictionAction getAction() {
        return this.action;
    }

    public void setAction(EvictionAction action) {
        this.action = action;
    }

    public EvictionType getType() {
        return this.type;
    }

    public void setType(EvictionType type) {
        this.type = type;
    }
}

