/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.listener.ContinuousQueryDefinition;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.data.gemfire.listener.adapter.ContinuousQueryListenerAdapter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GemfireListenerContainerParser
extends AbstractSingleBeanDefinitionParser {
    GemfireListenerContainerParser() {
    }

    protected Class<ContinuousQueryListenerContainer> getBeanClass(Element element) {
        return ContinuousQueryListenerContainer.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "phase");
        ParsingUtils.setPropertyValue(element, builder, "pool-name");
        ParsingUtils.setPropertyReference(element, builder, "cache", "cache");
        ParsingUtils.setPropertyReference(element, builder, "task-executor", "task-executor");
        List listDefs = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (!listDefs.isEmpty()) {
            ManagedSet listeners = new ManagedSet(listDefs.size());
            for (Element listElement : listDefs) {
                listeners.add((Object)this.parseListener(listElement));
            }
            builder.addPropertyValue("queryListeners", (Object)listeners);
        }
    }

    private BeanDefinition parseListener(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ContinuousQueryListenerAdapter.class);
        builder.addConstructorArgReference(element.getAttribute("ref"));
        String attr = element.getAttribute("method");
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue("defaultListenerMethod", (Object)attr);
        }
        BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition(ContinuousQueryDefinition.class);
        attr = element.getAttribute("name");
        if (StringUtils.hasText((String)attr)) {
            defBuilder.addConstructorArgValue((Object)attr);
        }
        defBuilder.addConstructorArgValue((Object)element.getAttribute("query"));
        defBuilder.addConstructorArgValue((Object)builder.getBeanDefinition());
        attr = element.getAttribute("durable");
        if (StringUtils.hasText((String)attr)) {
            defBuilder.addConstructorArgValue((Object)attr);
        }
        return defBuilder.getBeanDefinition();
    }
}

