/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.gemfire.function.DefaultFunctionArgumentResolver;
import org.springframework.data.gemfire.function.GemfireFunctionUtils;
import org.springframework.data.gemfire.function.annotation.Filter;
import org.springframework.data.gemfire.function.annotation.RegionData;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;

class FunctionContextInjectingArgumentResolver
extends DefaultFunctionArgumentResolver {
    private static Log logger = LogFactory.getLog(FunctionContextInjectingArgumentResolver.class);
    private final int regionParameterPosition;
    private final int filterParameterPosition;
    private final int functionContextParameterPosition;
    private final int resultSenderParameterPosition;
    private final Method method;

    public FunctionContextInjectingArgumentResolver(Method method) {
        this.method = method;
        int annotatedRegionDataParameterPosition = GemfireFunctionUtils.getAnnotationParameterPosition(method, RegionData.class, new Class[]{Map.class});
        int regionTypeParameterPosition = FunctionContextInjectingArgumentResolver.getArgumentTypePosition(method, Region.class);
        if (annotatedRegionDataParameterPosition >= 0 && regionTypeParameterPosition >= 0) {
            Assert.isTrue((annotatedRegionDataParameterPosition == regionTypeParameterPosition ? 1 : 0) != 0, (String)String.format("Function method signature for method %s cannot contain an @RegionData parameter and a different Region type parameter", method.getName()));
        }
        int tempRegionParameterPosition = -1;
        if (annotatedRegionDataParameterPosition >= 0) {
            tempRegionParameterPosition = annotatedRegionDataParameterPosition;
        } else if (regionTypeParameterPosition >= 0) {
            tempRegionParameterPosition = regionTypeParameterPosition;
        }
        this.regionParameterPosition = tempRegionParameterPosition;
        this.filterParameterPosition = GemfireFunctionUtils.getAnnotationParameterPosition(method, Filter.class, new Class[]{Set.class});
        this.functionContextParameterPosition = FunctionContextInjectingArgumentResolver.getArgumentTypePosition(method, FunctionContext.class);
        this.resultSenderParameterPosition = FunctionContextInjectingArgumentResolver.getArgumentTypePosition(method, ResultSender.class);
        if (this.regionParameterPosition >= 0 && this.filterParameterPosition >= 0) {
            Assert.state((this.regionParameterPosition != this.filterParameterPosition ? 1 : 0) != 0, (String)"region parameter and filter parameter must be different");
        }
    }

    @Override
    public Object[] resolveFunctionArguments(FunctionContext functionContext) {
        Object[] args = super.resolveFunctionArguments(functionContext);
        if (functionContext instanceof RegionFunctionContext) {
            if (this.regionParameterPosition >= 0) {
                args = ArrayUtils.insert(args, this.regionParameterPosition, FunctionContextInjectingArgumentResolver.getRegionForContext((RegionFunctionContext)functionContext));
            }
            if (this.filterParameterPosition >= 0) {
                args = ArrayUtils.insert(args, this.filterParameterPosition, ((RegionFunctionContext)functionContext).getFilter());
            }
            if (this.functionContextParameterPosition >= 0) {
                args = ArrayUtils.insert(args, this.functionContextParameterPosition, functionContext);
            }
            if (this.resultSenderParameterPosition >= 0) {
                args = ArrayUtils.insert(args, this.resultSenderParameterPosition, functionContext.getResultSender());
            }
        }
        Assert.isTrue((args.length == this.method.getParameterTypes().length ? 1 : 0) != 0, (String)String.format("wrong number of arguments for method %s. Expected :%d, actual: %d", this.method.getName(), this.method.getParameterTypes().length, args.length));
        return args;
    }

    private static Region<?, ?> getRegionForContext(RegionFunctionContext regionFunctionContext) {
        Region region = regionFunctionContext.getDataSet();
        if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"this is a partitioned region - filtering local data for context");
            }
            region = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)regionFunctionContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("region contains " + region.size() + " items"));
        }
        return region;
    }

    private static int getArgumentTypePosition(Method method, Class<?> requiredType) {
        int position = -1;
        int i = 0;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (requiredType.equals(clazz)) {
                Assert.state((position < 0 ? 1 : 0) != 0, (String)String.format("Method %s signature cannot contain more than one parameter of type %s.", method.getName(), requiredType.getName()));
                position = i;
            }
            ++i;
        }
        return position;
    }
}

