/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import com.gemstone.gemfire.cache.Region;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.Regions;
import org.springframework.data.gemfire.repository.query.DefaultGemfireEntityInformation;
import org.springframework.data.gemfire.repository.query.GemfireEntityInformation;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.PartTreeGemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.StringBasedGemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.support.SimpleGemfireRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class GemfireRepositoryFactory
extends RepositoryFactorySupport {
    private final MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context;
    private final Regions regions;

    public GemfireRepositoryFactory(Iterable<Region<?, ?>> regions, MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context) {
        Assert.notNull(regions);
        this.context = context == null ? new GemfireMappingContext() : context;
        this.regions = new Regions(regions, this.context);
    }

    public <T, ID extends Serializable> GemfireEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.context.getPersistentEntity(domainClass);
        return new DefaultGemfireEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        GemfireTemplate gemfireTemplate = this.getTemplate(metadata);
        return new SimpleGemfireRepository(gemfireTemplate, entityInformation);
    }

    private GemfireTemplate getTemplate(RepositoryMetadata metadata) {
        Class domainClass = metadata.getDomainType();
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.context.getPersistentEntity(domainClass);
        Region region = this.regions.getRegion(domainClass);
        if (region == null) {
            throw new IllegalStateException(String.format("No region '%s' found for domain class %s! Make sure you have configured a Gemfire region of that name in your application context!", entity.getRegionName(), domainClass));
        }
        Class regionKeyType = region.getAttributes().getKeyConstraint();
        Class entityIdType = metadata.getIdType();
        if (regionKeyType != null && entity.getIdProperty() != null) {
            Assert.isTrue((boolean)regionKeyType.isAssignableFrom(entityIdType), (String)String.format("The region referenced only supports keys of type %s but the entity to be stored has an id of type %s!", regionKeyType, entityIdType));
        }
        return new GemfireTemplate(region);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleGemfireRepository.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new QueryLookupStrategy(){

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
                GemfireQueryMethod queryMethod = new GemfireQueryMethod(method, metadata, GemfireRepositoryFactory.this.context);
                GemfireTemplate template = GemfireRepositoryFactory.this.getTemplate(metadata);
                if (queryMethod.hasAnnotatedQuery()) {
                    return new StringBasedGemfireRepositoryQuery(queryMethod, template);
                }
                String namedQueryName = queryMethod.getNamedQueryName();
                if (namedQueries.hasQuery(namedQueryName)) {
                    return new StringBasedGemfireRepositoryQuery(namedQueries.getQuery(namedQueryName), queryMethod, template);
                }
                return new PartTreeGemfireRepositoryQuery(queryMethod, template);
            }
        };
    }
}

