/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.util.Gateway;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;

public class AsyncEventQueueFactoryBean
extends AbstractWANComponentFactoryBean<AsyncEventQueue> {
    private static List<String> validOrderPolicyValues = Arrays.asList("KEY", "PARTITION", "THREAD");
    private final AsyncEventListener asyncEventListener;
    private AsyncEventQueue asyncEventQueue;
    private Integer batchSize;
    private Integer dispatcherThreads;
    private Integer batchTimeInterval;
    private Integer maximumQueueMemory;
    private Boolean persistent;
    private String diskStoreRef;
    private Boolean parallel;
    private Boolean diskSynchronous;
    private String orderPolicy;
    private Boolean batchConflationEnabled;

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreRef = diskStoreRef;
    }

    public AsyncEventQueueFactoryBean(Cache cache, AsyncEventListener asyncEventListener) {
        super(cache);
        this.asyncEventListener = asyncEventListener;
    }

    @Override
    public AsyncEventQueue getObject() throws Exception {
        return this.asyncEventQueue;
    }

    @Override
    public Class<?> getObjectType() {
        return AsyncEventQueue.class;
    }

    @Override
    protected void doInit() {
        Assert.notNull((Object)this.asyncEventListener, (String)"AsyncEventListener cannot be null");
        AsyncEventQueueFactory asyncEventQueueFactory = null;
        asyncEventQueueFactory = this.factory == null ? this.cache.createAsyncEventQueueFactory() : (AsyncEventQueueFactory)this.factory;
        if (this.diskStoreRef != null) {
            this.persistent = this.persistent == null ? Boolean.TRUE : this.persistent;
            Assert.isTrue((boolean)this.persistent, (String)"specifying a disk store requires persistent property to be true");
            asyncEventQueueFactory.setDiskStoreName(this.diskStoreRef);
        }
        if (this.diskSynchronous != null) {
            this.persistent = this.persistent == null ? Boolean.TRUE : this.persistent;
            Assert.isTrue((boolean)this.persistent, (String)"specifying a disk synchronous requires persistent property to be true");
            asyncEventQueueFactory.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.persistent != null) {
            asyncEventQueueFactory.setPersistent(this.persistent.booleanValue());
        }
        if (this.batchSize != null) {
            asyncEventQueueFactory.setBatchSize(this.batchSize.intValue());
        }
        if (this.batchTimeInterval != null) {
            asyncEventQueueFactory.setBatchTimeInterval(this.batchTimeInterval.intValue());
        }
        if (this.batchConflationEnabled != null) {
            asyncEventQueueFactory.setBatchConflationEnabled(this.batchConflationEnabled.booleanValue());
        }
        if (this.dispatcherThreads != null) {
            asyncEventQueueFactory.setDispatcherThreads(this.dispatcherThreads.intValue());
        }
        if (this.maximumQueueMemory != null) {
            asyncEventQueueFactory.setMaximumQueueMemory(this.maximumQueueMemory.intValue());
        }
        if (this.parallel != null) {
            asyncEventQueueFactory.setParallel(this.parallel.booleanValue());
        }
        if (this.orderPolicy != null) {
            Assert.isTrue((boolean)this.parallel, (String)"specifying an order policy requires the parallel property to be true");
            Assert.isTrue((boolean)validOrderPolicyValues.contains(this.orderPolicy.toUpperCase()), (String)("The value of order policy:'" + this.orderPolicy + "' is invalid"));
            asyncEventQueueFactory.setOrderPolicy(Gateway.OrderPolicy.valueOf((String)this.orderPolicy.toUpperCase()));
        }
        this.asyncEventQueue = asyncEventQueueFactory.create(this.getName(), this.asyncEventListener);
    }

    @Override
    public void destroy() throws Exception {
        if (!this.cache.isClosed()) {
            try {
                this.asyncEventListener.close();
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public static void setValidOrderPolicyValues(List<String> validOrderPolicyValues) {
        AsyncEventQueueFactoryBean.validOrderPolicyValues = validOrderPolicyValues;
    }

    public void setAsyncEventQueue(AsyncEventQueue asyncEventQueue) {
        this.asyncEventQueue = asyncEventQueue;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setOrderPolicy(String orderPolicy) {
        this.orderPolicy = orderPolicy;
    }
}

