/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionFactory;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class PartitionedRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
            Assert.isTrue((boolean)resolvedDataPolicy.withPartitioning(), (String)String.format("Data Policy '%1$s' is not supported in Partitioned Regions.", resolvedDataPolicy));
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            regionFactory.setDataPolicy(resolvedDataPolicy);
        } else if (this.isPersistent()) {
            Assert.isTrue((boolean)GemfireUtils.isGemfireVersion65OrAbove(), (String)String.format("Can define Persistent Partitioned Regions only from GemFire 6.5 onwards; current version is [%1$s]", CacheFactory.getVersion()));
            regionFactory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        } else {
            regionFactory.setDataPolicy(DataPolicy.PARTITION);
        }
    }
}

