/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionFactory;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class ReplicatedRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            if (DataPolicy.EMPTY.equals(resolvedDataPolicy)) {
                resolvedDataPolicy = DataPolicy.EMPTY;
            } else {
                Assert.isTrue((boolean)resolvedDataPolicy.withReplication(), (String)String.format("Data Policy '%1$s' is not supported in Replicated Regions.", resolvedDataPolicy));
            }
            regionFactory.setDataPolicy(resolvedDataPolicy);
        } else {
            regionFactory.setDataPolicy(this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE);
        }
    }
}

