/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SubRegionFactoryBean<K, V>
extends AttributesFactory<K, V>
implements FactoryBean<Region<K, V>>,
InitializingBean {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean lookupOnly;
    private CacheListener<K, V>[] cacheListeners;
    private Object[] asyncEventQueues;
    private Object[] gatewaySenders;
    private Region<?, ?> parentRegion;
    private Region<K, V> subRegion;
    private String name;
    private String regionName;

    public Region<K, V> getObject() throws Exception {
        return this.subRegion;
    }

    public Class<?> getObjectType() {
        return Region.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.parentRegion, (String)"The parent Region cannot be null.");
        this.subRegion = this.parentRegion.getSubregion(this.regionName);
        if (this.subRegion == null) {
            if (this.lookupOnly) {
                throw new BeanInitializationException(String.format("Cannot find Region [%1$s] in Cache %2$s", this.regionName, this.parentRegion.getRegionService()));
            }
            this.log.debug((Object)String.format("Creating sub-Region of [%1$s] with name [%2$s]...", this.parentRegion.getFullPath() != null ? this.parentRegion.getFullPath() : this.parentRegion.getName(), this.regionName));
            if (!ObjectUtils.isEmpty((Object[])this.asyncEventQueues)) {
                for (Object asyncEventQueue : this.asyncEventQueues) {
                    this.addAsyncEventQueueId(((AsyncEventQueue)asyncEventQueue).getId());
                }
            }
            if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
                for (CacheListener<K, V> listener : this.cacheListeners) {
                    this.addCacheListener((CacheListener)listener);
                }
            }
            if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
                for (Object gatewaySender : this.gatewaySenders) {
                    this.addGatewaySenderId(((GatewaySender)gatewaySender).getId());
                }
            }
            this.subRegion = this.parentRegion.createSubregion(this.regionName, this.create());
        }
    }

    public void setAsyncEventQueues(Object[] asyncEventQueues) {
        this.asyncEventQueues = asyncEventQueues;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setGatewaySenders(Object[] gatewaySenders) {
        this.gatewaySenders = gatewaySenders;
    }

    public void setLookupOnly(boolean lookupOnly) {
        this.lookupOnly = lookupOnly;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setParent(Region<?, ?> parent) {
        this.parentRegion = parent;
    }
}

